/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;
import java.util.ArrayList;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;

public class LiteCoordinateSequence
extends PackedCoordinateSequence {
    private static final GeometryFactory geomFac = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    private double[] coords;
    private int size;

    public LiteCoordinateSequence(double[] coords, int dimensions) {
        this.init(coords, dimensions);
    }

    void init(double[] coords, int dimensions) {
        this.dimension = dimensions;
        if (dimensions < 2) {
            throw new IllegalArgumentException("Invalid dimensions, must be at least 2");
        }
        if (coords.length % this.dimension != 0) {
            throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
        }
        this.coords = coords;
        this.size = coords.length / this.dimension;
    }

    public LiteCoordinateSequence(double[] coords) {
        this.init(coords, 2);
    }

    public LiteCoordinateSequence(float[] coordinates, int dimension) {
        double[] dcoords = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            dcoords[i] = coordinates[i];
        }
        this.init(dcoords, dimension);
    }

    public LiteCoordinateSequence(float[] coordinates) {
        this(coordinates, 2);
    }

    public LiteCoordinateSequence(Coordinate[] coordinates) {
        if (coordinates == null) {
            coordinates = new Coordinate[]{};
        }
        this.dimension = 2;
        this.coords = new double[coordinates.length * this.dimension];
        for (int i = 0; i < coordinates.length; ++i) {
            this.coords[i * this.dimension] = coordinates[i].x;
            if (this.dimension < 2) continue;
            this.coords[i * this.dimension + 1] = coordinates[i].y;
        }
        this.size = coordinates.length;
    }

    public LiteCoordinateSequence(int size, int dimension) {
        this.dimension = dimension;
        this.coords = new double[size * this.dimension];
        this.size = this.coords.length / dimension;
    }

    public LiteCoordinateSequence(LiteCoordinateSequence seq) {
        this.dimension = seq.dimension;
        this.size = seq.size;
        double[] orig = seq.getArray();
        this.coords = new double[orig.length];
        System.arraycopy(orig, 0, this.coords, 0, this.coords.length);
    }

    public Coordinate getCoordinateInternal(int i) {
        double x = this.coords[i * this.dimension];
        double y = this.coords[i * this.dimension + 1];
        double z = this.dimension == 2 ? Double.NaN : this.coords[i * this.dimension + 2];
        return new Coordinate(x, y, z);
    }

    public int size() {
        return this.size;
    }

    public Object clone() {
        double[] clone = new double[this.coords.length];
        System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
        return new LiteCoordinateSequence(clone, this.dimension);
    }

    public double getOrdinate(int index, int ordinate) {
        return this.coords[index * this.dimension + ordinate];
    }

    public double getX(int index) {
        return this.coords[index * this.dimension];
    }

    public double getY(int index) {
        return this.coords[index * this.dimension + 1];
    }

    public void setOrdinate(int index, int ordinate, double value) {
        this.coordRef = null;
        this.coords[index * this.dimension + ordinate] = value;
    }

    public Envelope expandEnvelope(Envelope env) {
        double miny;
        double minx;
        double maxx = minx = this.coords[0];
        double maxy = miny = this.coords[1];
        for (int i = 0; i < this.coords.length; i += this.dimension) {
            double x = this.coords[i];
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            double y = this.coords[i + 1];
            if (y < miny) {
                miny = y;
                continue;
            }
            if (!(y > maxy)) continue;
            maxy = y;
        }
        env.expandToInclude(minx, miny);
        env.expandToInclude(maxx, maxy);
        return env;
    }

    public double[] getArray() {
        return this.coords;
    }

    public void setArray(double[] coords2) {
        this.coords = coords2;
        this.size = this.coords.length / this.dimension;
        this.coordRef = null;
    }

    public void setArray(double[] coords2, int dimension) {
        this.coords = coords2;
        this.dimension = dimension;
        this.size = this.coords.length / dimension;
        this.coordRef = null;
    }

    public double[] getXYArray() {
        if (this.dimension == 2) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * 2];
        for (int t = 0; t < n; ++t) {
            result[t * 2] = this.getOrdinate(t, 0);
            result[t * 2 + 1] = this.getOrdinate(t, 1);
        }
        return result;
    }

    public static final Geometry cloneGeometry(Geometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory) {
            if (geom instanceof LineString) {
                return LiteCoordinateSequence.cloneGeometryLCS((LineString)geom);
            }
            if (geom instanceof Polygon) {
                return LiteCoordinateSequence.cloneGeometryLCS((Polygon)geom);
            }
            if (geom instanceof Point) {
                return LiteCoordinateSequence.cloneGeometryLCS((Point)geom);
            }
            return LiteCoordinateSequence.cloneGeometryLCS((GeometryCollection)geom);
        }
        if (geom instanceof LineString) {
            return LiteCoordinateSequence.cloneGeometry((LineString)geom);
        }
        if (geom instanceof Polygon) {
            return LiteCoordinateSequence.cloneGeometry((Polygon)geom);
        }
        if (geom instanceof Point) {
            return LiteCoordinateSequence.cloneGeometry((Point)geom);
        }
        return LiteCoordinateSequence.cloneGeometry((GeometryCollection)geom);
    }

    private static final Geometry cloneGeometryLCS(Polygon geom) {
        LinearRing lr = (LinearRing)LiteCoordinateSequence.cloneGeometryLCS((LinearRing)geom.getExteriorRing());
        LinearRing[] rings = new LinearRing[geom.getNumInteriorRing()];
        for (int t = 0; t < rings.length; ++t) {
            rings[t] = (LinearRing)LiteCoordinateSequence.cloneGeometryLCS((LinearRing)geom.getInteriorRingN(t));
        }
        return geomFac.createPolygon(lr, rings);
    }

    private static final Geometry cloneGeometryLCS(Point geom) {
        return geomFac.createPoint((CoordinateSequence)new LiteCoordinateSequence((LiteCoordinateSequence)geom.getCoordinateSequence()));
    }

    private static final Geometry cloneGeometryLCS(LineString geom) {
        return geomFac.createLineString((CoordinateSequence)new LiteCoordinateSequence((LiteCoordinateSequence)geom.getCoordinateSequence()));
    }

    private static final Geometry cloneGeometryLCS(LinearRing geom) {
        return geomFac.createLinearRing((CoordinateSequence)new LiteCoordinateSequence((LiteCoordinateSequence)geom.getCoordinateSequence()));
    }

    private static final Geometry cloneGeometryLCS(GeometryCollection geom) {
        if (geom.getNumGeometries() == 0) {
            Geometry[] gs = new Geometry[]{};
            return geomFac.createGeometryCollection(gs);
        }
        ArrayList<Geometry> gs = new ArrayList<Geometry>(geom.getNumGeometries());
        int n = geom.getNumGeometries();
        Class<?> geomType = geom.getGeometryN(0).getClass();
        for (int t = 0; t < n; ++t) {
            Geometry clone = LiteCoordinateSequence.cloneGeometry(geom.getGeometryN(t));
            if (clone.getClass() != geomType) {
                geomType = null;
            }
            gs.add(t, clone);
        }
        if (geomType == Point.class) {
            return geomFac.createMultiPoint(gs.toArray(new Point[gs.size()]));
        }
        if (geomType == LineString.class) {
            return geomFac.createMultiLineString(gs.toArray(new LineString[gs.size()]));
        }
        if (geomType == Polygon.class) {
            return geomFac.createMultiPolygon(gs.toArray(new Polygon[gs.size()]));
        }
        return geomFac.buildGeometry(gs);
    }

    private static final Geometry cloneGeometry(Polygon geom) {
        LinearRing lr = (LinearRing)LiteCoordinateSequence.cloneGeometry((LinearRing)geom.getExteriorRing());
        LinearRing[] rings = new LinearRing[geom.getNumInteriorRing()];
        for (int t = 0; t < rings.length; ++t) {
            rings[t] = (LinearRing)LiteCoordinateSequence.cloneGeometry((LinearRing)geom.getInteriorRingN(t));
        }
        return geomFac.createPolygon(lr, rings);
    }

    private static final Geometry cloneGeometry(Point geom) {
        return geomFac.createPoint((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinates()));
    }

    private static final Geometry cloneGeometry(LineString geom) {
        return geomFac.createLineString((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinates()));
    }

    private static final Geometry cloneGeometry(LinearRing geom) {
        return geomFac.createLinearRing((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinates()));
    }

    private static final Geometry cloneGeometry(GeometryCollection geom) {
        if (geom.getNumGeometries() == 0) {
            Geometry[] gs = new Geometry[]{};
            return geomFac.createGeometryCollection(gs);
        }
        ArrayList<Geometry> gs = new ArrayList<Geometry>(geom.getNumGeometries());
        int n = geom.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            gs.add(LiteCoordinateSequence.cloneGeometry(geom.getGeometryN(t)));
        }
        return geomFac.buildGeometry(gs);
    }
}

