/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.RandomFeatureAccess;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.util.SoftValueHashMap;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class SubFeatureList
extends SubFeatureCollection
implements RandomFeatureAccess {
    List<SortBy> sort;
    List<FeatureId> index;

    public SubFeatureList(SimpleFeatureCollection list, Filter filter) {
        this(list, filter, SortBy.NATURAL_ORDER);
    }

    public SubFeatureList(SimpleFeatureCollection list, SortBy sort) {
        this(list, (Filter)Filter.INCLUDE, sort);
    }

    public SubFeatureList(SimpleFeatureCollection list, Filter filter, SortBy subSort) {
        super(list, filter);
        if (subSort == null || subSort.equals(SortBy.NATURAL_ORDER)) {
            this.sort = Collections.emptyList();
        } else {
            this.sort = new ArrayList<SortBy>();
            if (this.collection instanceof SubFeatureList) {
                SubFeatureList sorted = (SubFeatureList)this.collection;
                this.sort.addAll(sorted.sort);
            }
            this.sort.add(subSort);
        }
        this.index = this.createIndex();
    }

    public SubFeatureList(SimpleFeatureCollection list, List order) {
        super(list);
        this.index = order;
        this.filter = null;
    }

    public SimpleFeature get(int position) {
        FeatureId fid = this.index.get(position);
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            return random.getFeatureMember(fid.getID());
        }
        SimpleFeatureIterator it = this.collection.features();
        try {
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                if (!this.id.equals(feature.getID())) continue;
                SimpleFeature simpleFeature = feature;
                return simpleFeature;
            }
            throw new IndexOutOfBoundsException();
        }
        finally {
            it.close();
        }
    }

    @Override
    protected Filter createFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
        Iterator<FeatureId> it = this.index.iterator();
        while (it.hasNext()) {
            featureIds.add(ff.featureId((String)it.next()));
        }
        Id fids = ff.id(featureIds);
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FeatureId> createIndex() {
        ArrayList<FeatureId> fids = new ArrayList<FeatureId>();
        SimpleFeatureIterator it = this.collection.features();
        try {
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                if (!this.filter.evaluate((Object)feature)) continue;
                fids.add(feature.getIdentifier());
            }
            if (this.sort != null && !this.sort.isEmpty()) {
                final SortBy initialOrder = this.sort.get(this.sort.size() - 1);
                final FeatureIdAccessor idAccessor = new FeatureIdAccessor(true);
                Collections.sort(fids, new Comparator<FeatureId>(){

                    @Override
                    public int compare(FeatureId key1, FeatureId key2) {
                        SimpleFeature feature2;
                        SimpleFeature feature1 = idAccessor.getFeature(key1.getID());
                        int compare = this.compare(feature1, feature2 = idAccessor.getFeature(key2.getID()), initialOrder);
                        if (compare == 0 && SubFeatureList.this.sort.size() > 1) {
                            for (int i = SubFeatureList.this.sort.size() - 1; compare == 0 && i >= 0; --i) {
                                compare = this.compare(feature1, feature2, SubFeatureList.this.sort.get(i));
                            }
                        }
                        return compare;
                    }

                    protected int compare(SimpleFeature feature1, SimpleFeature feature2, SortBy order) {
                        Comparable value2;
                        PropertyName name = order.getPropertyName();
                        Comparable value1 = (Comparable)name.evaluate((Object)feature1);
                        if (value1 == (value2 = (Comparable)name.evaluate((Object)feature2))) {
                            return 0;
                        }
                        if (order.getSortOrder() == SortOrder.ASCENDING) {
                            if (value1 == null) {
                                return -1;
                            }
                            return value1.compareTo(value2);
                        }
                        if (value2 == null) {
                            return -1;
                        }
                        return value2.compareTo(value1);
                    }
                });
            }
        }
        finally {
            it.close();
        }
        return fids;
    }

    @Override
    public boolean add(SimpleFeature feature) {
        boolean added = this.collection.add(feature);
        if (added) {
            this.index.add(feature.getIdentifier());
        }
        return true;
    }

    public int indexOf(SimpleFeature feature) {
        return this.index.indexOf(feature.getIdentifier());
    }

    public int lastIndexOf(SimpleFeature feature) {
        return this.index.lastIndexOf(feature.getIdentifier());
    }

    @Override
    public SimpleFeatureCollection subList(Filter subfilter) {
        if (this.filter.equals(Filter.INCLUDE)) {
            return this;
        }
        if (this.filter.equals(Filter.EXCLUDE)) {
            // empty if block
        }
        return new SubFeatureList(this.collection, (Filter)this.ff.and(this.filter, subfilter), this.sort.get(0));
    }

    @Override
    public SimpleFeature getFeatureMember(String id) throws NoSuchElementException {
        int position = this.index.indexOf(this.ff.featureId(id));
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        return new FeatureIdAccessor(false).getFeature(id);
    }

    @Override
    public SimpleFeature removeFeatureMember(String id) {
        int position = this.index.indexOf(this.ff.featureId(id));
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            if (this.index != null) {
                this.index.remove(id);
            }
            return random.removeFeatureMember(id);
        }
        return this.remove(position);
    }

    public SimpleFeature remove(int position) {
        FeatureId fid = this.index.get(position);
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            return random.removeFeatureMember(fid.getID());
        }
        SimpleFeature feature = new FeatureIdAccessor(false).getFeature(this.id);
        this.collection.remove(feature);
        return feature;
    }

    @Override
    public Iterator<SimpleFeature> openIterator() {
        return new SortedIteratory();
    }

    private class FeatureIdAccessor {
        SoftValueHashMap<String, SimpleFeature> featureCache;
        private boolean cacheFeatures;

        public FeatureIdAccessor(boolean cacheFeatures) {
            this.cacheFeatures = cacheFeatures;
            if (cacheFeatures) {
                this.featureCache = new SoftValueHashMap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SimpleFeature getFeature(String id) {
            if (SubFeatureList.this.collection instanceof RandomFeatureAccess) {
                RandomFeatureAccess random = (RandomFeatureAccess)SubFeatureList.this.collection;
                return random.getFeatureMember(id);
            }
            if (this.cacheFeatures) {
                SimpleFeature result = (SimpleFeature)this.featureCache.get((Object)id);
                if (result != null) {
                    return result;
                }
                SimpleFeatureIterator it = SubFeatureList.this.collection.features();
                try {
                    while (it.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)it.next();
                        this.featureCache.put((Object)id, (Object)feature);
                        if (!id.equals(feature.getID())) continue;
                        SimpleFeature simpleFeature = feature;
                        return simpleFeature;
                    }
                }
                finally {
                    it.close();
                }
                throw new RuntimeException("Could not find feature with id " + id);
            }
            SimpleFeatureIterator it = SubFeatureList.this.collection.features();
            try {
                while (it.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)it.next();
                    if (!id.equals(feature.getID())) continue;
                    SimpleFeature simpleFeature = feature;
                    return simpleFeature;
                }
            }
            finally {
                it.close();
            }
            throw new RuntimeException("Could not find feature with id " + id);
        }
    }

    private class SortedIteratory
    implements Iterator<SimpleFeature> {
        Iterator<FeatureId> iterator;
        String id;
        FeatureIdAccessor idAccessor;

        private SortedIteratory() {
            this.iterator = SubFeatureList.this.index.iterator();
            this.idAccessor = new FeatureIdAccessor(true);
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public SimpleFeature next() {
            FeatureId fid = this.iterator.next();
            this.id = fid.getID();
            return this.idAccessor.getFeature(this.id);
        }

        @Override
        public void remove() {
            SubFeatureList.this.removeFeatureMember(this.id);
        }
    }
}

