/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.coverage;

import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@UML(identifier="CV_Coverage", specification=Specification.ISO_19123)
public interface Coverage {
    @UML(identifier="CRS", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    @UML(identifier="envelope", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public Envelope getEnvelope();

    @UML(identifier="rangeType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public RecordType getRangeType();

    @UML(identifier="evaluate", obligation=Obligation.MANDATORY, specification=Specification.ISO_19123)
    public Set<Record> evaluate(DirectPosition var1, Collection<String> var2) throws PointOutsideCoverageException, CannotEvaluateException;

    @UML(identifier="evaluate", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public Object evaluate(DirectPosition var1) throws PointOutsideCoverageException, CannotEvaluateException;

    @UML(identifier="evaluateAsBoolean", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public boolean[] evaluate(DirectPosition var1, boolean[] var2) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="evaluateAsByte", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public byte[] evaluate(DirectPosition var1, byte[] var2) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="evaluateAsInteger", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public int[] evaluate(DirectPosition var1, int[] var2) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException;

    public float[] evaluate(DirectPosition var1, float[] var2) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="evaluateAsDouble", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public double[] evaluate(DirectPosition var1, double[] var2) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException;

    @UML(identifier="numSampleDimensions", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public int getNumSampleDimensions();

    @UML(identifier="getSampleDimension", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public SampleDimension getSampleDimension(int var1) throws IndexOutOfBoundsException;

    @UML(identifier="getSource, numSource", obligation=Obligation.MANDATORY, specification=Specification.OGC_01004)
    public List<? extends Coverage> getSources();

    public RenderableImage getRenderableImage(int var1, int var2) throws UnsupportedOperationException, IndexOutOfBoundsException;
}

