/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.stream.FileCacheImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;

public class ImageIOExt {
    static Long filesystemThreshold = null;
    static File cacheDirectory = null;

    public static ImageOutputStream createImageOutputStream(RenderedImage image, Object destination) throws IOException {
        if (destination instanceof ImageOutputStream) {
            return (ImageOutputStream)destination;
        }
        if (destination instanceof OutputStream && filesystemThreshold != null && image != null) {
            OutputStream stream = (OutputStream)destination;
            long imageSize = ImageIOExt.computeImageSize(image);
            if (imageSize > filesystemThreshold) {
                File cacheDirectory = ImageIOExt.getCacheDirectory();
                return new FileCacheImageOutputStream(stream, cacheDirectory);
            }
            return new MemoryCacheImageOutputStream(stream);
        }
        return ImageIO.createImageOutputStream(destination);
    }

    public static ImageInputStream createImageInputStream(Object input) throws IOException {
        return ImageIO.createImageInputStream(input);
    }

    public static File getCacheDirectory() {
        File cacheDir = cacheDirectory;
        if (cacheDir == null) {
            cacheDir = ImageIO.getCacheDirectory();
        }
        return cacheDir;
    }

    public static void setCacheDirectory(File cache) {
        cacheDirectory = cache;
    }

    public static Long getFilesystemThreshold() {
        return filesystemThreshold;
    }

    public static void setFilesystemThreshold(Long filesystemThreshold) {
        ImageIOExt.filesystemThreshold = filesystemThreshold;
    }

    public static synchronized <T extends ImageReaderWriterSpi> void allowNativeCodec(String format, Class<T> category, boolean allowed) {
        ImageReaderWriterSpi standard = null;
        ImageReaderWriterSpi codeclib = null;
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<T> it = registry.getServiceProviders(category, false);
        block0: while (it.hasNext()) {
            ImageReaderWriterSpi provider = (ImageReaderWriterSpi)it.next();
            String[] formats = provider.getFormatNames();
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equalsIgnoreCase(format)) continue;
                if (Classes.getShortClassName((Object)provider).startsWith("CLib")) {
                    codeclib = provider;
                    continue block0;
                }
                standard = provider;
                continue block0;
            }
        }
        if (standard != null && codeclib != null) {
            if (allowed) {
                registry.setOrdering(category, codeclib, standard);
            } else {
                registry.setOrdering(category, standard, codeclib);
            }
        }
    }

    public static final ImageInputStreamSpi getImageInputStreamSPI(Object input) {
        return ImageIOExt.getImageInputStreamSPI(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageInputStreamSpi getImageInputStreamSPI(Object input, boolean streamCreationCheck) {
        Iterator<ImageInputStreamSpi> iter;
        try {
            iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageInputStreamSpi.class, true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        boolean usecache = ImageIO.getUseCache();
        ImageInputStreamSpi spi = null;
        while (iter.hasNext()) {
            spi = iter.next();
            if (!spi.getInputClass().isInstance(input)) continue;
            if (!streamCreationCheck) break;
            ImageInputStream stream = null;
            try {
                stream = spi.createInputStreamInstance(input, usecache, ImageIO.getCacheDirectory());
                break;
            }
            catch (IOException e) {
                ImageInputStreamSpi imageInputStreamSpi = null;
                return imageInputStreamSpi;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        return spi;
    }

    public static boolean isCLibAvailable() {
        return PackageUtil.isCodecLibAvailable();
    }

    public static ImageReader getImageioReader(ImageInputStream inStream) {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static long computeImageSize(RenderedImage image) {
        long bits = 0L;
        int bands = image.getSampleModel().getNumBands();
        for (int i = 0; i < bands; ++i) {
            bits += (long)image.getSampleModel().getSampleSize(i);
        }
        return (long)Math.ceil(bits / 8L) * (long)image.getWidth() * (long)image.getHeight();
    }
}

