/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Point;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawnPolyLine {
    MapView mv;
    private LinkedList<LatLon> points = new LinkedList();
    private LinkedList<LatLon> simplePoints = new LinkedList();
    private Set<LatLon> used;
    private Set<LatLon> fixed = new HashSet<LatLon>();
    private int lastIdx;
    private boolean closedFlag;

    public DrawnPolyLine() {
        this.clear();
    }

    public void setMv(MapView mv) {
        this.mv = mv;
    }

    boolean isFixed(LatLon pp2) {
        return this.fixed.contains(pp2);
    }

    double getLength() {
        LinkedList<LatLon> pts = this.getPoints();
        if (pts.size() < 2) {
            return 0.0;
        }
        ListIterator it1 = pts.listIterator(0);
        ListIterator it2 = pts.listIterator(1);
        double len = 0.0;
        for (int i = 0; i < pts.size() - 1; ++i) {
            LatLon pp1 = (LatLon)it1.next();
            LatLon pp2 = (LatLon)it2.next();
            len += pp1.greatCircleDistance(pp2);
        }
        return len;
    }

    LinkedList<LatLon> getPoints() {
        if (this.simplePoints != null) {
            return this.simplePoints;
        }
        return this.points;
    }

    boolean wasSimplified() {
        return this.simplePoints != null && this.simplePoints.size() > 0;
    }

    int findClosestPoint(Point p, double d) {
        double x = p.x;
        double y = p.y;
        int n = this.points.size();
        int idx = -1;
        double minD = 1.0E10;
        for (int i = 0; i < n; ++i) {
            double dist = Math.sqrt(this.getPoint(this.points.get(i)).distanceSq(x, y));
            if (!(dist < d) || !(dist < minD)) continue;
            idx = i;
            minD = dist;
        }
        return idx;
    }

    void clear() {
        this.points.clear();
        this.used = null;
        this.lastIdx = 0;
        this.closedFlag = false;
        this.fixed.clear();
        this.simplePoints = null;
    }

    void undo() {
        if (this.lastIdx > 0 && this.lastIdx < this.points.size()) {
            this.points.remove(this.lastIdx);
            --this.lastIdx;
        }
    }

    void fixPoint(LatLon p) {
        this.fixed.add(p);
    }

    void addFixed(LatLon coor) {
        this.addLast(coor);
        this.fixed.add(coor);
    }

    void addLast(LatLon coor) {
        if (this.closedFlag && this.lastIdx > this.points.size() - 1) {
            return;
        }
        if (this.lastIdx >= this.points.size() - 1) {
            this.points.addLast(coor);
            if (this.points.size() > 1) {
                ++this.lastIdx;
            }
        } else {
            this.points.add(this.lastIdx + 1, coor);
            ++this.lastIdx;
        }
    }

    Point getLastPoint() {
        if (this.lastIdx < this.points.size()) {
            return this.getPoint(this.points.get(this.lastIdx));
        }
        return null;
    }

    Point getPoint(LatLon p) {
        return this.mv.getPoint(p);
    }

    int getSimplePointsCount() {
        if (this.simplePoints != null) {
            return this.simplePoints.size();
        }
        return -1;
    }

    double autoSimplify(double initEpsilon, double ekf, int k, double maxPKM) {
        double e = initEpsilon;
        if (e < 0.001) {
            e = 0.001;
        }
        if (ekf < 1.01) {
            ekf = 1.01;
        }
        this.simplify(e);
        while (this.getNodesPerKm(k) > maxPKM && e < 1000.0) {
            this.simplify(e *= ekf);
        }
        return e;
    }

    void simplify(double epsilon) {
        int n = this.points.size();
        if (n < 3) {
            return;
        }
        this.used = new HashSet<LatLon>(n);
        int start = 0;
        for (int i = 0; i < n; ++i) {
            LatLon p = this.points.get(i);
            if (!this.fixed.contains(p) && i != n - 1) continue;
            if (start < 0) {
                start = i;
                continue;
            }
            this.douglasPeucker(start, i, epsilon, 0);
        }
        this.simplePoints = new LinkedList();
        this.simplePoints.addAll(this.points);
        this.simplePoints.retainAll(this.used);
        this.used = null;
    }

    private void douglasPeucker(int start, int end, double epsilon, int depth) {
        if (depth > 500) {
            return;
        }
        if (end - start < 1) {
            return;
        }
        LatLon first = this.points.get(start);
        LatLon last = this.points.get(end);
        Point firstp = this.getPoint(first);
        Point lastp = this.getPoint(last);
        this.used.add(first);
        this.used.add(last);
        if (end - start < 2) {
            return;
        }
        int farthest_node = -1;
        double farthest_dist = 0.0;
        double d = 0.0;
        for (int i = start + 1; i < end; ++i) {
            d = this.pointLineDistance(this.getPoint(this.points.get(i)), firstp, lastp);
            if (!(d > farthest_dist)) continue;
            farthest_dist = d;
            farthest_node = i;
        }
        if (farthest_dist > epsilon) {
            this.douglasPeucker(start, farthest_node, epsilon, depth + 1);
            this.douglasPeucker(farthest_node, end, epsilon, depth + 1);
        }
    }

    public double pointLineDistance(Point p1, Point p2, Point p3) {
        double x0 = p1.x;
        double y0 = p1.y;
        double x1 = p2.x;
        double y1 = p2.y;
        double x2 = p3.x;
        double y2 = p3.y;
        if (x2 == x1 && y2 == y1) {
            return Math.hypot(x1 - x0, y1 - y0);
        }
        return Math.abs((x2 - x1) * (y1 - y0) - (x1 - x0) * (y2 - y1)) / Math.hypot(x2 - x1, y2 - y1);
    }

    void closeLine() {
        this.points.add(this.points.getFirst());
        this.closedFlag = true;
    }

    boolean isClosed() {
        return this.closedFlag;
    }

    void deleteNode(int idx) {
        if (idx <= this.lastIdx) {
            --this.lastIdx;
        }
        this.fixed.remove(this.points.get(idx));
        this.points.remove(idx);
    }

    void tryToDeleteSegment(Point p) {
        if (this.points.size() < 3) {
            return;
        }
        LatLon start = this.findBigSegment(p);
        ListIterator it = this.points.listIterator();
        boolean f = false;
        int i = 0;
        int idx = -1;
        while (it.hasNext()) {
            LatLon pp = (LatLon)it.next();
            if (f && this.fixed.contains(pp)) {
                this.lastIdx = idx;
                return;
            }
            if (f && !it.hasNext()) {
                this.closedFlag = false;
                it.remove();
                this.lastIdx = this.points.size() - 1;
                return;
            }
            if (f) {
                it.remove();
            }
            if (pp == start) {
                f = true;
                idx = i;
            }
            ++i;
        }
        this.lastIdx = this.points.size() - 1;
    }

    LatLon findBigSegment(Point p) {
        if (this.points.size() < 2) {
            return null;
        }
        ListIterator<LatLon> it1 = this.points.listIterator(0);
        ListIterator<LatLon> it2 = this.points.listIterator(1);
        LatLon start = null;
        start = this.points.getFirst();
        do {
            LatLon pp1 = (LatLon)it1.next();
            LatLon pp2 = (LatLon)it2.next();
            Point p1 = this.getPoint(pp1);
            Point p2 = this.getPoint(pp2);
            if (this.fixed.contains(pp1)) {
                start = pp1;
            }
            if (!(this.pointSegmentDistance(p, p1, p2) < 5.0)) continue;
            return start;
        } while (it2.hasNext());
        return null;
    }

    private double pointSegmentDistance(Point p, Point p1, Point p2) {
        double x = p.x - p1.x;
        double y = p.y - p1.y;
        double a = p2.x - p1.x;
        double b = p2.y - p1.y;
        double l = Math.hypot(a, b);
        if (l == 0.0) {
            return Math.hypot(x, y);
        }
        double kt = (x * a + y * b) / l;
        double kn = Math.abs((-x * b + y * a) / l);
        double dist = kt >= 0.0 && kt < l ? kn : Math.min(Math.hypot(x, y), Math.hypot(x - a, y - b));
        return dist;
    }

    void clearSimplifiedVersion() {
        this.simplePoints = null;
    }

    boolean isLastPoint(int i) {
        return this.lastIdx == i;
    }

    void moveToTheEnd() {
        this.lastIdx = this.points.size() - 1;
    }

    void toggleFixed(int idx) {
        LatLon p = this.points.get(idx);
        if (this.fixed.contains(p)) {
            this.fixed.remove(p);
        } else {
            this.fixed.add(p);
        }
    }

    void moveNode(int dragNode, LatLon coor) {
        LatLon dragged = this.points.get(dragNode);
        if (this.closedFlag && this.points.getFirst().equals((Object)dragged)) {
            this.points.set(0, coor);
            this.points.set(this.points.size() - 1, coor);
        } else {
            this.points.set(dragNode, coor);
        }
        if (this.fixed.contains(dragged)) {
            this.fixed.remove(dragged);
            this.fixed.add(coor);
        }
    }

    public double getNodesPerKm(int k) {
        int n;
        LinkedList<LatLon> pts = this.simplePoints;
        if (!this.wasSimplified()) {
            pts = this.points;
        }
        if ((n = pts.size()) < 2) {
            return 0.0;
        }
        if (k < 2) {
            k = 2;
        }
        if (k > n) {
            k = n;
        }
        LatLon pp2 = null;
        ListIterator it1 = pts.listIterator(0);
        ListIterator it2 = pts.listIterator(1);
        double[] lens = new double[n];
        for (int i = 0; i < n - 1; ++i) {
            LatLon pp1 = (LatLon)it1.next();
            pp2 = (LatLon)it2.next();
            lens[i] = pp1.greatCircleDistance(pp2);
        }
        double pkm = 0.0;
        double maxpkm = 0.0;
        double len = 0.0;
        int seg = 0;
        for (int i = 1; i < n; ++i) {
            len += lens[i - 1];
            if (i > k) {
                seg = k;
                len -= lens[i - k - 1];
            } else {
                seg = i;
            }
            if (i < k && i != n - 1) continue;
            if (len > 0.0) {
                pkm = (double)seg / len * 1000.0;
            }
            if (!(pkm > maxpkm)) continue;
            maxpkm = pkm;
        }
        return Math.round(maxpkm);
    }

    int getPointCount() {
        return this.points.size();
    }
}

