/*
 * Decompiled with CFR 0.152.
 */
package namefinder;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import uk.co.wilson.xml.MinML2;

public class PlaceSelection
implements DownloadSelection {
    private JTextField searchTerm = new JTextField();
    private JButton submitSearch = new JButton(I18n.tr((String)"Search..."));
    private DefaultListModel searchResults = new DefaultListModel();
    private JList searchResultDisplay = new JList(this.searchResults);
    private boolean updatingSelf;

    public void queryServer() {
        try {
            URL uRL = new URL("http://www.frankieandshadow.com/osm/search.xml?find=" + URLEncoder.encode(this.searchTerm.getText(), "UTF-8"));
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            System.out.println("got return: " + httpURLConnection.getResponseCode());
            httpURLConnection.setConnectTimeout(15000);
            InputStream inputStream = httpURLConnection.getInputStream();
            new Parser().parse(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot read place search results from server"));
            exception.printStackTrace();
        }
    }

    public void addGui(final DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr((String)"Enter a place name to search for:")), GBC.eol());
        jPanel.add((Component)this.searchTerm, GBC.std().fill(2));
        jPanel.add((Component)this.submitSearch, GBC.eol());
        GBC gBC = GBC.eol();
        gBC.gridwidth = 2;
        jPanel.add((Component)new JScrollPane(this.searchResultDisplay), gBC);
        downloadDialog.tabpane.add((Component)jPanel, "Places");
        this.submitSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlaceSelection.this.queryServer();
            }
        });
        this.searchResultDisplay.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    this.setText(((SearchResult)object).name);
                    this.setToolTipText("<html>" + ((SearchResult)object).description + "</html>");
                }
                return this;
            }
        });
        this.searchResultDisplay.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SearchResult searchResult = null;
                try {
                    searchResult = (SearchResult)PlaceSelection.this.searchResults.getElementAt(listSelectionEvent.getFirstIndex());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (searchResult != null) {
                    double d = 180.0 / Math.pow(2.0, searchResult.zoom);
                    downloadDialog.minlat = searchResult.lat - d / 2.0;
                    downloadDialog.maxlat = searchResult.lat + d / 2.0;
                    downloadDialog.minlon = searchResult.lon - d;
                    downloadDialog.maxlon = searchResult.lon + d;
                    PlaceSelection.this.updatingSelf = true;
                    downloadDialog.boundingBoxChanged(null);
                    PlaceSelection.this.updatingSelf = false;
                }
            }
        });
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        if (!this.updatingSelf) {
            this.searchResultDisplay.clearSelection();
        }
    }

    private class Parser
    extends MinML2 {
        private SearchResult currentResult = null;
        private StringBuffer description = null;
        private int depth = 0;

        private Parser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.depth;
            try {
                if (string3.equals("searchresults")) {
                    PlaceSelection.this.searchResults.clear();
                } else if (string3.equals("named") && this.depth == 2) {
                    this.currentResult = new SearchResult();
                    this.currentResult.name = attributes.getValue("name");
                    this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                    this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                    this.currentResult.zoom = Integer.parseInt(attributes.getValue("zoom"));
                    PlaceSelection.this.searchResults.addElement(this.currentResult);
                } else if (string3.equals("description") && this.depth == 3) {
                    this.description = new StringBuffer();
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new SAXException(numberFormatException.getMessage(), numberFormatException);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new SAXException(I18n.tr((String)"NullPointerException. Possible some missing tags."), nullPointerException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals("searchresults") && string3.equals("description") && this.description != null) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.description != null) {
                this.description.append(cArray, n, n2);
            }
        }
    }

    class SearchResult {
        public String name;
        public String description;
        public double lat;
        public double lon;
        public int zoom;

        SearchResult() {
        }
    }
}

