/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.roadsigns;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignInputDialog;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignsReader;
import org.openstreetmap.josm.plugins.roadsigns.Sign;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class RoadSignsPlugin
extends Plugin {
    static PresetMetaData selectedPreset;
    public static List<Sign> signs;
    public static List<String> iconDirs;
    public static final PresetMetaData PRESET_DE;
    public static final PresetMetaData PRESET_PL;
    public static final PresetMetaData PRESET_SK;
    public static final Collection<PresetMetaData> DEFAULT_PRESETS;

    public RoadSignsPlugin(PluginInformation info) {
        super(info);
        this.registerAction();
    }

    private void registerAction() {
        JButton btn = new JButton((Action)((Object)new RoadSignAction()));
        btn.setText(null);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setPreferredSize(new Dimension(18, 18));
        PropertiesDialog.pluginHook.add(btn);
        PropertiesDialog.pluginHook.setLayout(new FlowLayout(1, 0, 0));
    }

    public static void setSelectedPreset(PresetMetaData preset) throws IOException {
        Main.pref.put("plugin.roadsigns.preset.selection", preset.code);
        RoadSignsPlugin.loadSignPreset();
    }

    public static List<PresetMetaData> getAvailablePresetsMetaData() {
        Collection customFiles;
        List presetsData = Main.pref.getListOfStructs("plugin.roadsigns.presets", DEFAULT_PRESETS, PresetMetaData.class);
        String customFile = Main.pref.get("plugin.roadsigns.sources", null);
        if (customFile == null && (customFiles = Main.pref.getCollection("plugin.roadsigns.sources", null)) != null && !customFiles.isEmpty()) {
            customFile = (String)customFiles.iterator().next();
        }
        if (customFile != null) {
            String lastCustomFile = Main.pref.get("plugin.roadsigns.sources.last", null);
            if (!Utils.equal((Object)customFile, (Object)lastCustomFile)) {
                Main.pref.put("plugin.roadsigns.sources.last", customFile);
                Main.pref.put("plugin.roadsigns.preset.selection", "custom");
            }
            String customIconDirsStr = Main.pref.get("plugin.roadsigns.icon.sources", null);
            ArrayList<String> customIconDirs = null;
            customIconDirs = customIconDirsStr != null ? new ArrayList<String>(Arrays.asList(customIconDirsStr.split(","))) : Main.pref.getCollection("plugin.roadsigns.icon.sources", null);
            customIconDirs = customIconDirs != null ? new ArrayList<String>(customIconDirs) : new ArrayList();
            if (!customFile.startsWith("resource:")) {
                String parentDir = null;
                try {
                    URL url = new URL(customFile);
                    parentDir = url.getPath();
                }
                catch (MalformedURLException ex) {
                    File f = new File(customFile);
                    parentDir = f.getParent();
                }
                if (parentDir != null && !parentDir.isEmpty()) {
                    customIconDirs.add(parentDir);
                }
            }
            if (Main.pref.getBoolean("plugin.roadsigns.use_default_icon_source", true)) {
                customIconDirs.add("resource://images/");
            }
            PresetMetaData custom = new PresetMetaData("custom", I18n.tr((String)"custom", (Object[])new Object[0]), customFile, Utils.join((String)",", customIconDirs));
            presetsData.add(custom);
        } else {
            Main.pref.put("plugin.roadsigns.sources.last", null);
        }
        return presetsData;
    }

    protected static void loadSignPreset() throws IOException {
        List<PresetMetaData> presetsData = RoadSignsPlugin.getAvailablePresetsMetaData();
        String code = Main.pref.get("plugin.roadsigns.preset.selection", null);
        for (PresetMetaData data : presetsData) {
            if (!data.code.equals(code)) continue;
            selectedPreset = data;
            break;
        }
        if (selectedPreset == null) {
            selectedPreset = !presetsData.isEmpty() ? presetsData.get(0) : PRESET_DE;
        }
        iconDirs = Arrays.asList(RoadSignsPlugin.selectedPreset.icon_path.split(","));
        String source = RoadSignsPlugin.selectedPreset.preset_path;
        try {
            InputStream in = RoadSignsPlugin.getInputStream(source);
            RoadSignsReader reader = new RoadSignsReader(in);
            signs = reader.parse();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read tagging preset source: ''{0}''", (Object[])new Object[]{source}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            throw ex;
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error parsing tagging preset from ''{0}'':\n", (Object[])new Object[]{source}) + ex.getMessage(), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            throw new IOException(ex);
        }
    }

    public static InputStream getInputStream(String source) throws IOException {
        Object in = null;
        in = source.startsWith("http://") || source.startsWith("ftp://") ? new MirroredInputStream(source) : (source.startsWith("file:") ? new URL(source).openStream() : (source.startsWith("resource://") ? RoadSignsPlugin.class.getResourceAsStream(source.substring("resource:/".length())) : new FileInputStream(source)));
        return in;
    }

    static {
        PRESET_DE = new PresetMetaData("DE", I18n.tr((String)"Germany", (Object[])new Object[0]), "resource://data/roadsignpresetDE.xml", "resource://images/DE/");
        PRESET_PL = new PresetMetaData("PL", I18n.tr((String)"Poland", (Object[])new Object[0]), "resource://data/roadsignpresetPL.xml", "resource://images/PL/");
        PRESET_SK = new PresetMetaData("SK", I18n.tr((String)"Slovakia", (Object[])new Object[0]), "resource://data/roadsignpresetSK.xml", "resource://images/SK/");
        DEFAULT_PRESETS = Arrays.asList(PRESET_DE, PRESET_PL, PRESET_SK);
    }

    public static class PresetMetaData {
        @Preferences.pref
        public String code;
        @Preferences.pref
        public String display_name;
        @Preferences.pref
        public String preset_path;
        @Preferences.pref
        public String icon_path;

        public PresetMetaData() {
        }

        public PresetMetaData(String country_code, String display_name, String preset_path, String icons_path) {
            this.code = country_code;
            this.display_name = display_name;
            this.preset_path = preset_path;
            this.icon_path = icons_path;
        }

        public String toString() {
            return this.display_name;
        }
    }

    private static class RoadSignAction
    extends JosmAction {
        public RoadSignAction() {
            super(I18n.tr((String)"Roadsign tagging", (Object[])new Object[0]), "pref/roadsigns-small", I18n.tr((String)"Add tags by clicking on road signs", (Object[])new Object[0]), Shortcut.registerShortcut((String)"plugin:roadsigns:dialog", (String)I18n.tr((String)"Roadsigns plugin: open dialog", (Object[])new Object[0]), (int)81, (int)5007), false);
        }

        public void actionPerformed(ActionEvent e) {
            String code = Main.pref.get("plugin.roadsigns.preset.selection", null);
            if (code == null) {
                ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr((String)"Settings", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
                ed.setButtonIcons(new String[]{"ok", "cancel"});
                RoadSignInputDialog.SettingsPanel settings = new RoadSignInputDialog.SettingsPanel(true, null);
                ed.setContent((Component)settings);
                ed.showDialog();
                if (ed.getValue() != 1) {
                    return;
                }
                try {
                    settings.apply();
                }
                catch (IOException ex) {
                    return;
                }
            }
            try {
                RoadSignsPlugin.loadSignPreset();
            }
            catch (IOException ex) {
                return;
            }
            RoadSignInputDialog input = new RoadSignInputDialog();
            input.showDialog();
        }
    }
}

