/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Tag;

public class TextTagParser {
    int start = 0;
    boolean keyFound = false;
    boolean quotesStarted = false;
    boolean esc = false;
    StringBuilder s = new StringBuilder(200);
    int pos = 0;
    String data;
    int n;
    boolean notFound;

    public TextTagParser(String text) {
        this.data = text;
        this.n = this.data.length();
    }

    Collection<Tag> getFormattedTags() {
        String[] lines = this.data.split("\n");
        Pattern p = Pattern.compile("(.*?)\t(.*?)");
        ArrayList<Tag> tags = new ArrayList<Tag>();
        String k = null;
        String v = null;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            Matcher m = p.matcher(line);
            if (m.matches()) {
                k = m.group(1).trim();
                v = m.group(2).trim();
                tags.add(new Tag(k, v));
                continue;
            }
            tags.clear();
            break;
        }
        if (!tags.isEmpty()) {
            return tags;
        }
        return null;
    }

    Collection<Tag> getParsedTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (true) {
            this.skipEmpty();
            if (this.pos == this.n) break;
            String k = this.parseString(true);
            if (this.pos == this.n) {
                tags.clear();
                break;
            }
            this.skipSign();
            if (this.pos == this.n) {
                tags.clear();
                break;
            }
            String v = this.parseString(false);
            tags.add(new Tag(k, v));
        }
        return tags;
    }

    private String parseString(boolean stopOnEquals) {
        while (this.pos < this.n) {
            char c = this.data.charAt(this.pos);
            if (this.esc) {
                this.esc = false;
                this.s.append(c);
            } else if (c == '\\') {
                this.esc = true;
            } else if (c == '\"' && !this.quotesStarted) {
                if (this.s.toString().trim().length() > 0) {
                    this.s.append(c);
                } else {
                    this.s.delete(0, this.s.length());
                    this.quotesStarted = true;
                }
            } else {
                if (c == '\"' && this.quotesStarted) {
                    this.quotesStarted = false;
                    ++this.pos;
                    break;
                }
                if (!this.quotesStarted && (c == '\n' || c == '\t' || c == ' ' || c == '\r' || c == '=' && stopOnEquals)) {
                    ++this.pos;
                    break;
                }
                if (c >= ' ') {
                    this.s.append(c);
                }
            }
            ++this.pos;
        }
        String res = this.s.toString();
        this.s.delete(0, this.s.length());
        return res.trim();
    }

    private void skipSign() {
        boolean signFound = false;
        while (this.pos < this.n) {
            char c = this.data.charAt(this.pos);
            if (c == '\t' || c == '\n' || c == ' ') {
                ++this.pos;
                continue;
            }
            if (c != '=' || signFound) break;
            signFound = true;
            ++this.pos;
        }
    }

    private void skipEmpty() {
        char c;
        while (this.pos < this.n && ((c = this.data.charAt(this.pos)) == '\t' || c == '\n' || c == '\r' || c == ' ')) {
            ++this.pos;
        }
    }

    public static Collection<Tag> readTagsFromText(String buf) {
        TextTagParser parser = new TextTagParser(buf);
        Collection<Tag> tags = parser.getFormattedTags();
        if (tags == null) {
            tags = parser.getParsedTags();
        }
        return tags;
    }
}

