/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UnGlueRelationAction
extends JosmAction {
    public UnGlueRelationAction() {
        super(I18n.tr((String)"UnGlue Relation", (Object[])new Object[0]), "ungluerelations", I18n.tr((String)"Duplicate nodes, ways and relations that are used by multiple relations.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:ungluerelation", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"UnGlue Relations", (Object[])new Object[0])}), (int)71, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/UnGlueRelation"));
    }

    public void actionPerformed(ActionEvent e) {
        LinkedList<Object> cmds = new LinkedList<Object>();
        LinkedList<Node> newPrimitives = new LinkedList<Node>();
        Collection selection = UnGlueRelationAction.getCurrentDataSet().getSelected();
        for (OsmPrimitive p : selection) {
            boolean first = true;
            for (Relation relation : OsmPrimitive.getFilteredList((Collection)p.getReferrers(), Relation.class)) {
                if (relation.isDeleted()) continue;
                if (!first) {
                    Node newp;
                    switch (p.getType()) {
                        case NODE: {
                            newp = new Node((Node)p, true);
                            break;
                        }
                        case WAY: {
                            newp = new Way((Way)p, true);
                            break;
                        }
                        case RELATION: {
                            newp = new Relation((Relation)p, true);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    newPrimitives.add(newp);
                    cmds.add(new AddCommand((OsmPrimitive)newp));
                    cmds.add((Object)new ChangeRelationMemberCommand(relation, p, (OsmPrimitive)newp));
                    continue;
                }
                first = false;
            }
        }
        if (!newPrimitives.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Unglued Relations", (Object[])new Object[0]), cmds));
            newPrimitives.addAll(selection);
            UnGlueRelationAction.getCurrentDataSet().setSelected(newPrimitives);
            Main.map.mapView.repaint();
        }
    }

    protected void updateEnabledState() {
        if (UnGlueRelationAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UnGlueRelationAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private class ChangeRelationMemberCommand
    extends Command {
        private final Relation relation;
        private final OsmPrimitive oldMember;
        private final OsmPrimitive newMember;

        public ChangeRelationMemberCommand(Relation relation, OsmPrimitive oldMember, OsmPrimitive newMember) {
            this.relation = relation;
            this.oldMember = oldMember;
            this.newMember = newMember;
        }

        private boolean replaceMembers(OsmPrimitive oldP, OsmPrimitive newP) {
            if (this.relation == null || this.oldMember == null || this.newMember == null) {
                return false;
            }
            LinkedList<RelationMember> newrms = new LinkedList<RelationMember>();
            for (RelationMember rm : this.relation.getMembers()) {
                if (rm.getMember() == oldP) {
                    newrms.add(new RelationMember(rm.getRole(), newP));
                    continue;
                }
                newrms.add(rm);
            }
            this.relation.setMembers(newrms);
            return true;
        }

        public boolean executeCommand() {
            return this.replaceMembers(this.oldMember, this.newMember);
        }

        public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
            modified.add((OsmPrimitive)this.relation);
        }

        public void undoCommand() {
            this.replaceMembers(this.newMember, this.oldMember);
        }

        public String getDescriptionText() {
            return I18n.tr((String)"Change relation member for {0} {1}", (Object[])new Object[]{OsmPrimitiveType.from((IPrimitive)this.relation), this.relation.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
        }
    }
}

