/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.utilsplugin2.helper.TextTagParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PasteTagsExtendedAction
extends JosmAction {
    public PasteTagsExtendedAction() {
        super(I18n.tr((String)"Paste tags [testing]", (Object[])new Object[0]), "pastetags", I18n.tr((String)"Apply tags parsed from buffer to all selected items..", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:pastetags", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Paste tags", (Object[])new Object[0])}), (int)84, (int)5006), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = PasteTagsExtendedAction.getCurrentDataSet().getSelected();
        if (selection.isEmpty()) {
            return;
        }
        String buf = Utils.getClipboardContent();
        if (buf == null) {
            return;
        }
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        for (Tag tag : TextTagParser.readTagsFromText(buf)) {
            commands.add(new ChangePropertyCommand(selection, tag.getKey(), "".equals(tag.getValue()) ? null : tag.getValue()));
        }
        if (!commands.isEmpty()) {
            String title1 = I18n.trn((String)"Pasting {0} tag", (String)"Pasting {0} tags", (long)commands.size(), (Object[])new Object[]{commands.size()});
            String title2 = I18n.trn((String)"to {0} object", (String)"to {0} objects", (long)selection.size(), (Object[])new Object[]{selection.size()});
            Main.main.undoRedo.add((Command)new SequenceCommand(title1 + " " + title2, commands));
        }
    }

    protected void updateEnabledState() {
        if (PasteTagsExtendedAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(PasteTagsExtendedAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

