/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmarender;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OsmarenderPlugin
extends Plugin {
    private JMenuItem osmarenderMenu;

    public OsmarenderPlugin(PluginInformation info) throws IOException {
        super(info);
        this.osmarenderMenu = MainMenu.add((JMenu)Main.main.menu.viewMenu, (JosmAction)new Action());
        this.osmarenderMenu.setVisible(false);
        this.copy("/osmarender.xsl", "osmarender.xsl");
        this.copy("/osm-map-features.xml", "osm-map-features.xml");
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame != null && newFrame == null) {
            this.osmarenderMenu.setVisible(false);
        } else if (oldFrame == null && newFrame != null) {
            this.osmarenderMenu.setVisible(true);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new OsmarenderPreferenceSetting();
    }

    private void writeGenerated(Bounds b) throws IOException {
        String bounds_tag = "<bounds minlat=\"" + b.getMin().lat() + "\" " + "maxlat=\"" + b.getMax().lat() + "\" " + "minlon=\"" + b.getMin().lon() + "\" " + "maxlon=\"" + b.getMax().lon() + "\" " + "/>";
        BufferedReader reader = new BufferedReader(new FileReader(this.getPluginDir() + File.separator + "osm-map-features.xml"));
        PrintWriter writer = new PrintWriter(this.getPluginDir() + File.separator + "generated.xml");
        String str = null;
        while ((str = reader.readLine()) != null) {
            if (str.contains("<!--bounds_mkr1-->")) {
                writer.println(str);
                writer.println("    " + bounds_tag);
                while (!str.contains("<!--bounds_mkr2-->")) {
                    str = reader.readLine();
                }
                writer.println(str);
                continue;
            }
            writer.println(str);
        }
        writer.close();
    }

    private class OsmarenderPreferenceSetting
    implements SubPreferenceSetting {
        private JTextField firefox = new JTextField(10);

        private OsmarenderPreferenceSetting() {
        }

        public void addGui(PreferenceTabbedPane gui) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            panel.add((Component)new JLabel(I18n.tr((String)"Firefox executable", (Object[])new Object[0])), GBC.std().insets(10, 5, 5, 0));
            panel.add((Component)this.firefox, GBC.eol().insets(0, 5, 0, 0).fill(2));
            panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
            this.firefox.setText(Main.pref.get("osmarender.firefox"));
            gui.getMapPreference().mapcontent.addTab(I18n.tr((String)"Osmarender", (Object[])new Object[0]), panel);
        }

        public boolean ok() {
            Main.pref.put("osmarender.firefox", this.firefox.getText());
            return false;
        }

        public boolean isExpert() {
            return false;
        }

        public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
            return gui.getMapPreference();
        }
    }

    private class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr((String)"Osmarender", (Object[])new Object[0]), (String)null, I18n.tr((String)"Osmarender", (Object[])new Object[0]), null, true, "osmarender", true);
        }

        public void actionPerformed(ActionEvent e) {
            LatLon bottomLeft = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
            LatLon topRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
            Bounds b = new Bounds(bottomLeft, topRight);
            try {
                OsmarenderPlugin.this.writeGenerated(b);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String firefox = Main.pref.get("osmarender.firefox", "firefox");
            try {
                OsmWriter w = OsmWriterFactory.createOsmWriter((PrintWriter)new PrintWriter(new FileOutputStream(OsmarenderPlugin.this.getPluginDir() + File.separator + "data.osm")), (boolean)false, (String)"0.6");
                w.header();
                HashSet<Node> parents = new HashSet<Node>();
                for (Node node : Main.main.getCurrentDataSet().getNodes()) {
                    if (!node.isUsable() || !node.getCoor().isWithin(b)) continue;
                    parents.addAll(node.getReferrers());
                    w.visit((INode)node);
                }
                for (OsmPrimitive osmPrimitive : new HashSet(parents)) {
                    if (!(osmPrimitive instanceof Way)) continue;
                    for (Node n : ((Way)osmPrimitive).getNodes()) {
                        if (!n.getCoor().isWithin(b)) continue;
                        parents.add(n);
                    }
                }
                for (OsmPrimitive osmPrimitive : parents) {
                    if (!(osmPrimitive instanceof Way)) continue;
                    w.visit((IWay)((Way)osmPrimitive));
                }
                for (OsmPrimitive osmPrimitive : parents) {
                    if (!(osmPrimitive instanceof Relation)) continue;
                    w.visit((IRelation)((Relation)osmPrimitive));
                }
                w.footer();
                w.close();
                String exec = firefox;
                exec = System.getProperty("os.name").startsWith("Windows") ? exec + " file:///" + OsmarenderPlugin.this.getPluginDir().replace('\\', '/').replace(" ", "%20") + File.separator + "generated.xml\"" : exec + " " + OsmarenderPlugin.this.getPluginDir() + File.separator + "generated.xml";
                Runtime.getRuntime().exec(exec);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Firefox not found. Please set firefox executable in the Map Settings page of the preferences.", (Object[])new Object[0]));
            }
        }
    }
}

