/*
 * Decompiled with CFR 0.152.
 */
package nanolog;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import nanolog.NanoLogEntry;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NanoLogLayer
extends Layer
implements JumpToMarkerActions.JumpToMarkerLayer {
    private List<NanoLogEntry> log;
    private int selectedEntry;

    public NanoLogLayer(File file) throws IOException {
        super(I18n.tr((String)"NanoLog", (Object[])new Object[0]));
        this.log = NanoLogLayer.readNanoLog(file);
        this.selectedEntry = -1;
    }

    public static List<NanoLogEntry> readNanoLog(File file) throws IOException {
        ArrayList<NanoLogEntry> result = new ArrayList<NanoLogEntry>();
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
        while (r.ready()) {
            String line = r.readLine();
            if (line == null) continue;
        }
        r.close();
        return result;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        int radius = 4;
        int width = Main.map.mapView.getWidth();
        int height = Main.map.mapView.getHeight();
        Rectangle clip = g.getClipBounds();
        for (NanoLogEntry entry : this.log) {
            if (entry.getPos() == null) continue;
            Point p = mv.getPoint(entry.getPos());
            g.setColor(Color.green);
            g.fillOval(p.x - radius, p.y - radius, radius * 2, radius * 2);
        }
        if (this.selectedEntry >= 0 && this.selectedEntry < this.log.size()) {
            Point p = mv.getPoint(this.log.get(this.selectedEntry).getPos());
            g.setColor(Color.red);
            g.fillOval(p.x - radius, p.y - radius, radius * 2, radius * 2);
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"nanolog.png");
    }

    public String getToolTipText() {
        return I18n.tr((String)"NanoLog of {0} entries", (Object[])new Object[]{this.log.size()});
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return other instanceof NanoLogLayer;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (NanoLogEntry entry : this.log) {
            v.visit(entry.getPos());
        }
    }

    public Object getInfoComponent() {
        StringBuilder b = new StringBuilder();
        int cnt = 0;
        for (NanoLogEntry e : this.log) {
            if (e.getPos() == null) continue;
            ++cnt;
        }
        b.append(I18n.tr((String)"NanoLog of {0} lines, {1} of them with coordinates.", (Object[])new Object[]{this.log.size(), cnt}));
        return b.toString();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new CorrelateEntries(), new SaveLayer(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public void jumpToNextMarker() {
        ++this.selectedEntry;
        if (this.selectedEntry < 0) {
            this.selectedEntry = 0;
        } else if (this.selectedEntry >= this.log.size()) {
            this.selectedEntry = this.log.size() - 1;
        }
        Main.map.repaint();
    }

    public void jumpToPreviousMarker() {
        --this.selectedEntry;
        if (this.selectedEntry < 0) {
            this.selectedEntry = 0;
        } else if (this.selectedEntry >= this.log.size()) {
            this.selectedEntry = this.log.size() - 1;
        }
        Main.map.repaint();
    }

    private class SaveLayer
    extends AbstractAction {
        private SaveLayer() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class CorrelateEntries
    extends AbstractAction {
        private CorrelateEntries() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

