/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.formats.pnm.FileInfo;
import org.apache.sanselan.formats.pnm.WhiteSpaceReader;

public class PBMFileInfo
extends FileInfo {
    private int bitcache = 0;
    private int bits_in_cache = 0;

    public PBMFileInfo(int width, int height, boolean RAWBITS) {
        super(width, height, RAWBITS);
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public int getBitDepth() {
        return 1;
    }

    @Override
    public ImageFormat getImageType() {
        return ImageFormat.IMAGE_FORMAT_PBM;
    }

    @Override
    public int getColorType() {
        return 0;
    }

    @Override
    public String getImageTypeDescription() {
        return "PBM: portable bitmap fileformat";
    }

    @Override
    public String getMIMEType() {
        return "image/x-portable-bitmap";
    }

    @Override
    protected void newline() {
        this.bitcache = 0;
        this.bits_in_cache = 0;
    }

    @Override
    public int getRGB(InputStream is) throws IOException {
        if (this.bits_in_cache < 1) {
            int bits = is.read();
            if (bits < 0) {
                throw new IOException("PBM: Unexpected EOF");
            }
            this.bitcache = 0xFF & bits;
            this.bits_in_cache += 8;
        }
        int bit = 1 & this.bitcache >> 7;
        this.bitcache <<= 1;
        --this.bits_in_cache;
        if (bit == 0) {
            return -1;
        }
        if (bit == 1) {
            return -16777216;
        }
        throw new IOException("PBM: bad bit: " + bit);
    }

    @Override
    public int getRGB(WhiteSpaceReader wsr) throws IOException {
        int bit = Integer.parseInt(wsr.readtoWhiteSpace());
        if (bit == 0) {
            return -16777216;
        }
        if (bit == 1) {
            return -1;
        }
        throw new IOException("PBM: bad bit: " + bit);
    }
}

