/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class WikipediaApp {
    private WikipediaApp() {
    }

    static List<WikipediaEntry> getEntriesFromCoordinates(String wikipediaLang, LatLon min, LatLon max) {
        try {
            String bbox = min.lon() + "," + min.lat() + "," + max.lon() + "," + max.lat();
            String url = "http://toolserver.org/~kolossos/geoworld/marks.php?bbox=" + bbox + "&LANG=" + wikipediaLang;
            System.out.println("Wikipedia: GET " + url);
            XPathExpression xpathPlacemark = XPathFactory.newInstance().newXPath().compile("//Placemark");
            XPathExpression xpathName = XPathFactory.newInstance().newXPath().compile("name/text()");
            XPathExpression xpathCoord = XPathFactory.newInstance().newXPath().compile("Point/coordinates/text()");
            XPathExpression xpathDescr = XPathFactory.newInstance().newXPath().compile("description");
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new URL(url).openStream());
            NodeList nodes = (NodeList)xpathPlacemark.evaluate(doc, XPathConstants.NODESET);
            ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                String[] coord = xpathCoord.evaluate(nodes.item(i)).split(",");
                if (coord.length <= 2) continue;
                String name = xpathName.evaluate(nodes.item(i));
                String descr = xpathDescr.evaluate(nodes.item(i));
                entries.add(new WikipediaEntry(name, descr, new LatLon(Double.parseDouble(coord[1]), Double.parseDouble(coord[0]))));
            }
            return entries;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static List<WikipediaEntry> getEntriesFromCategory(String wikipediaLang, String category, int depth) {
        try {
            String url = "http://toolserver.org/~simon04/cats.php?lang=" + wikipediaLang + "&depth=" + depth + "&cat=" + WikipediaApp.encodeURL(category);
            System.out.println("Wikipedia: GET " + url);
            Scanner scanner = new Scanner(new URL(url).openStream(), "UTF-8").useDelimiter("\n");
            ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>();
            while (scanner.hasNext()) {
                String article = scanner.next().trim().replace("_", " ");
                entries.add(new WikipediaEntry(article, wikipediaLang, article));
            }
            return entries;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static void updateWIWOSMStatus(String wikipediaLang, Collection<WikipediaEntry> entries) {
        ArrayList<String> articleNames = new ArrayList<String>();
        for (WikipediaEntry i : entries) {
            articleNames.add(i.wikipediaArticle);
        }
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        if (!articleNames.isEmpty()) {
            String url = "http://toolserver.org/~master/osmjson/getGeoJSON.php?action=check&lang=" + wikipediaLang;
            System.out.println("Wikipedia: GET " + url);
            try {
                URLConnection connection = new URL(url).openConnection();
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                out.write("articles=" + WikipediaApp.encodeURL(Utils.join((String)",", articleNames)));
                out.close();
                Scanner scanner = new Scanner(connection.getInputStream()).useDelimiter("\n");
                while (scanner.hasNext()) {
                    String line = scanner.next();
                    String[] x = line.split("\t");
                    if (x.length == 2) {
                        status.put(x[0], "1".equals(x[1]));
                        continue;
                    }
                    System.err.println("Unknown element " + line);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (WikipediaEntry i : entries) {
            i.setWiwosmStatus((Boolean)status.get(i.wikipediaArticle));
        }
    }

    static Collection<String> getWikipediaArticles(String wikipediaLang, OsmPrimitive p) {
        String[] item;
        ArrayList<String> r = new ArrayList<String>();
        Map tags = p.getKeys();
        String wp = (String)tags.get("wikipedia");
        if (wp != null && wp.startsWith("http")) {
            item = WikipediaLangArticle.parseFromUrl(wp);
            if (item != null && wikipediaLang.equals(item.lang)) {
                r.add(item.article.replace("_", " "));
            }
        } else if (wp != null && (item = WikipediaApp.decodeURL(wp).split(":", 2)).length == 2 && wikipediaLang.equals(item[0])) {
            r.add(item[1].replace("_", " "));
        }
        String wpLang = (String)tags.get("wikipedia:" + wikipediaLang);
        if (wpLang != null && wpLang.startsWith("http")) {
            WikipediaLangArticle item2 = WikipediaLangArticle.parseFromUrl(wpLang);
            if (wikipediaLang.equals(item2.lang)) {
                r.add(item2.article.replace("_", " "));
            }
        } else if (wpLang != null) {
            String[] item3;
            r.add(item3[(item3 = WikipediaApp.decodeURL(wpLang).split(":", 2)).length == 2 ? 1 : 0].replace("_", " "));
        }
        return r;
    }

    static Collection<WikipediaLangArticle> getInterwikiArticles(String wikipediaLang, String article) {
        try {
            ArrayList<WikipediaLangArticle> r = new ArrayList<WikipediaLangArticle>();
            String url = "http://" + wikipediaLang + ".wikipedia.org/w/api.php" + "?action=query" + "&prop=langlinks" + "&titles=" + article + "&lllimit=500" + "&format=xml";
            System.out.println("Wikipedia: GET " + url);
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new URL(url).openStream());
            NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().compile("//ll").evaluate(xml, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String lang = nodes.item(i).getAttributes().getNamedItem("lang").getTextContent();
                String name = nodes.item(i).getTextContent();
                r.add(new WikipediaLangArticle(lang, name));
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static class WikipediaEntry
    implements Comparable<WikipediaEntry> {
        final String name;
        final String description;
        final String wikipediaLang;
        final String wikipediaArticle;
        final LatLon coordinate;
        private Boolean wiwosmStatus;

        public WikipediaEntry(String name, String description, LatLon coordinate) {
            this.name = name;
            this.description = description;
            this.coordinate = coordinate;
            WikipediaLangArticle wp = WikipediaLangArticle.parseFromUrl(this.getHrefFromDescription());
            if (wp == null) {
                System.err.println("Could not extract Wikipedia tag from: " + this.getHrefFromDescription());
            }
            this.wikipediaLang = wp == null ? null : wp.lang;
            this.wikipediaArticle = wp == null ? null : wp.article;
        }

        public WikipediaEntry(String name, String wikipediaLang, String wikipediaArticle) {
            this.name = name;
            this.description = null;
            this.wikipediaLang = wikipediaLang;
            this.wikipediaArticle = wikipediaArticle;
            this.coordinate = null;
        }

        protected final String getHrefFromDescription() {
            if (this.description == null) {
                return null;
            }
            Matcher m = Pattern.compile(".*href=\"(.+?)\".*").matcher(this.description);
            if (m.matches()) {
                return m.group(1);
            }
            System.err.println("Could not parse URL from: " + this.description);
            return null;
        }

        protected final Tag createWikipediaTag() {
            return new Tag("wikipedia", this.wikipediaLang + ":" + this.wikipediaArticle);
        }

        private void updateWiwosmStatus() {
            try {
                String url = "http://toolserver.org/~master/osmjson/getGeoJSON.php?action=check&lang=" + this.wikipediaLang + "&article=" + WikipediaApp.encodeURL(this.wikipediaArticle);
                System.out.println("Wikipedia: GET " + url);
                Scanner scanner = new Scanner(new URL(url).openStream());
                this.wiwosmStatus = scanner.hasNextInt() && scanner.nextInt() == 1;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setWiwosmStatus(Boolean wiwosmStatus) {
            this.wiwosmStatus = wiwosmStatus;
        }

        public Boolean getWiwosmStatus() {
            return this.wiwosmStatus;
        }

        public String getBrowserUrl() {
            if (this.getHrefFromDescription() != null) {
                return this.getHrefFromDescription().replace(" ", "_");
            }
            return "http://" + this.wikipediaLang + ".wikipedia.org/wiki/" + WikipediaApp.encodeURL(this.wikipediaArticle.replace(" ", "_"));
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(WikipediaEntry o) {
            return this.name.compareTo(o.name);
        }
    }

    static class WikipediaLangArticle {
        final String lang;
        final String article;

        public WikipediaLangArticle(String lang, String article) {
            this.lang = lang;
            this.article = article;
        }

        public static WikipediaLangArticle parseFromUrl(String url) {
            if (url == null) {
                return null;
            }
            url = WikipediaApp.decodeURL(url);
            Matcher m = Pattern.compile("https?://(\\w*)\\.wikipedia\\.org/wiki/(.*)").matcher(url);
            if (!m.matches()) {
                return null;
            }
            return new WikipediaLangArticle(m.group(1), m.group(2));
        }
    }
}

