/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.roadsigns;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignInputDialog;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignsReader;
import org.openstreetmap.josm.plugins.roadsigns.Sign;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class RoadSignsPlugin
extends Plugin {
    private static boolean presetsLoaded = false;
    public static List<Sign> signs;
    static List<String> iconDirs;

    public RoadSignsPlugin(PluginInformation info) {
        super(info);
        this.registerAction();
    }

    private void registerAction() {
        JButton btn = new JButton((Action)((Object)new RoadSignAction()));
        btn.setText(null);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setPreferredSize(new Dimension(18, 18));
        PropertiesDialog.pluginHook.add(btn);
        PropertiesDialog.pluginHook.setLayout(new FlowLayout(1, 0, 0));
    }

    protected static void loadSignPresets() {
        if (presetsLoaded) {
            return;
        }
        presetsLoaded = true;
        ArrayList files = new ArrayList(Main.pref.getCollection("plugin.roadsigns.sources", Collections.singletonList("resource://data/defaultroadsignpreset.xml")));
        iconDirs = new ArrayList<String>(Main.pref.getCollection("plugin.roadsigns.icon.sources", Collections.emptySet()));
        if (Main.pref.getBoolean("plugin.roadsigns.use_default_icon_source", true)) {
            iconDirs.add("resource://images/");
        }
        for (String source : files) {
            try {
                InputStream in = RoadSignsPlugin.getInputStream(source);
                RoadSignsReader reader = new RoadSignsReader(in);
                signs = reader.parse();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read tagging preset source: ''{0}''", (Object[])new Object[]{source}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
            catch (SAXException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error parsing tagging preset from ''{0}'':\n", (Object[])new Object[]{source}) + ex.getMessage(), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        }
    }

    public static InputStream getInputStream(String source) throws IOException {
        Object in = null;
        in = source.startsWith("http://") || source.startsWith("ftp://") ? new MirroredInputStream(source) : (source.startsWith("file:") ? new URL(source).openStream() : (source.startsWith("resource://") ? RoadSignsPlugin.class.getResourceAsStream(source.substring("resource:/".length())) : new FileInputStream(source)));
        return in;
    }

    private static class RoadSignAction
    extends JosmAction {
        public RoadSignAction() {
            super(I18n.tr((String)"Roadsign tagging", (Object[])new Object[0]), "pref/roadsigns-small", I18n.tr((String)"Add tags by clicking on road signs", (Object[])new Object[0]), Shortcut.registerShortcut((String)"plugin:roadsigns:dialog", (String)I18n.tr((String)"Roadsigns plugin: open dialog", (Object[])new Object[0]), (int)81, (int)5007), false);
        }

        public void actionPerformed(ActionEvent e) {
            RoadSignsPlugin.loadSignPresets();
            RoadSignInputDialog input = new RoadSignInputDialog(signs);
            input.showDialog();
        }
    }
}

