/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class NoteStructureSubRecord
extends SubRecord {
    public static final short sid = 13;
    private static final int ENCODED_SIZE = 22;
    private byte[] reserved;

    public NoteStructureSubRecord() {
        this.reserved = new byte[22];
    }

    public NoteStructureSubRecord(LittleEndianInput littleEndianInput, int n) {
        if (n != 22) {
            throw new RecordFormatException("Unexpected size (" + n + ")");
        }
        byte[] byArray = new byte[n];
        littleEndianInput.readFully(byArray);
        this.reserved = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ftNts ]").append("\n");
        stringBuffer.append("  size     = ").append(this.getDataSize()).append("\n");
        stringBuffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append("\n");
        stringBuffer.append("[/ftNts ]").append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(13);
        littleEndianOutput.writeShort(this.reserved.length);
        littleEndianOutput.write(this.reserved);
    }

    @Override
    protected int getDataSize() {
        return this.reserved.length;
    }

    public short getSid() {
        return 13;
    }

    @Override
    public Object clone() {
        NoteStructureSubRecord noteStructureSubRecord = new NoteStructureSubRecord();
        byte[] byArray = new byte[this.reserved.length];
        System.arraycopy(this.reserved, 0, byArray, 0, byArray.length);
        noteStructureSubRecord.reserved = byArray;
        return noteStructureSubRecord;
    }
}

