/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.units;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.osgeo.proj4j.util.ProjectionMath;

public class AngleFormat
extends NumberFormat {
    public static final String ddmmssPattern = "DdM";
    public static final String ddmmssPattern2 = "DdM'S\"";
    public static final String ddmmssLongPattern = "DdM'S\"W";
    public static final String ddmmssLatPattern = "DdM'S\"N";
    public static final String ddmmssPattern4 = "DdMmSs";
    public static final String decimalPattern = "D.F";
    private DecimalFormat format;
    private String pattern;
    private boolean isDegrees;

    public AngleFormat() {
        this(ddmmssPattern);
    }

    public AngleFormat(String pattern) {
        this(pattern, false);
    }

    public AngleFormat(String pattern, boolean isDegrees) {
        this.pattern = pattern;
        this.isDegrees = isDegrees;
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(0);
        this.format.setGroupingUsed(false);
    }

    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        return this.format((double)number, result, fieldPosition);
    }

    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        double ddmmss;
        int iddmmss;
        int length = this.pattern.length();
        boolean negative = false;
        if (number < 0.0) {
            for (int i = length - 1; i >= 0; --i) {
                char c = this.pattern.charAt(i);
                if (c != 'W' && c != 'N') continue;
                number = -number;
                negative = true;
                break;
            }
        }
        if ((iddmmss = (int)Math.round((ddmmss = this.isDegrees ? number : Math.toDegrees(number)) * 3600.0)) < 0) {
            iddmmss = -iddmmss;
        }
        int fraction = iddmmss % 3600;
        block10: for (int i = 0; i < length; ++i) {
            char c = this.pattern.charAt(i);
            switch (c) {
                case 'R': {
                    result.append(number);
                    continue block10;
                }
                case 'D': {
                    result.append((int)ddmmss);
                    continue block10;
                }
                case 'M': {
                    int f = fraction / 60;
                    if (f < 10) {
                        result.append('0');
                    }
                    result.append(f);
                    continue block10;
                }
                case 'S': {
                    int f = fraction % 60;
                    if (f < 10) {
                        result.append('0');
                    }
                    result.append(f);
                    continue block10;
                }
                case 'F': {
                    result.append(fraction);
                    continue block10;
                }
                case 'W': {
                    if (negative) {
                        result.append('W');
                        continue block10;
                    }
                    result.append('E');
                    continue block10;
                }
                case 'N': {
                    if (negative) {
                        result.append('S');
                        continue block10;
                    }
                    result.append('N');
                    continue block10;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result;
    }

    public Number parse(String text, ParsePosition parsePosition) {
        double result;
        int i;
        double d = 0.0;
        double m = 0.0;
        double s = 0.0;
        boolean negate = false;
        int length = text.length();
        if (length > 0) {
            char c = Character.toUpperCase(text.charAt(length - 1));
            switch (c) {
                case 'S': 
                case 'W': {
                    negate = true;
                }
                case 'E': 
                case 'N': {
                    text = text.substring(0, length - 1);
                }
            }
        }
        if ((i = text.indexOf(100)) == -1) {
            i = text.indexOf(176);
        }
        if (i != -1) {
            String dd = text.substring(0, i);
            String mmss = text.substring(i + 1);
            d = Double.valueOf(dd);
            i = mmss.indexOf(109);
            if (i == -1) {
                i = mmss.indexOf(39);
            }
            if (i != -1) {
                if (i != 0) {
                    String mm = mmss.substring(0, i);
                    m = Double.valueOf(mm);
                }
                if (mmss.endsWith("s") || mmss.endsWith("\"")) {
                    mmss = mmss.substring(0, mmss.length() - 1);
                }
                if (i != mmss.length() - 1) {
                    String ss = mmss.substring(i + 1);
                    s = Double.valueOf(ss);
                }
                if (m < 0.0 || m > 59.0) {
                    throw new NumberFormatException("Minutes must be between 0 and 59");
                }
                if (s < 0.0 || s >= 60.0) {
                    throw new NumberFormatException("Seconds must be between 0 and 59");
                }
            } else if (i != 0) {
                m = Double.valueOf(mmss);
            }
            result = this.isDegrees ? ProjectionMath.dmsToDeg(d, m, s) : ProjectionMath.dmsToRad(d, m, s);
        } else {
            result = Double.parseDouble(text);
            if (!this.isDegrees) {
                result = Math.toRadians(result);
            }
        }
        if (parsePosition != null) {
            parsePosition.setIndex(text.length());
        }
        if (negate) {
            result = -result;
        }
        return new Double(result);
    }
}

