/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j;

import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.Proj4jException;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.GeocentricConverter;

public class BasicCoordinateTransform
implements CoordinateTransform {
    private CoordinateReferenceSystem srcCRS;
    private CoordinateReferenceSystem tgtCRS;
    private ProjCoordinate geoCoord = new ProjCoordinate(0.0, 0.0);
    private boolean doInverseProjection = true;
    private boolean doForwardProjection = true;
    private boolean doDatumTransform = false;
    private boolean transformViaGeocentric = false;
    private GeocentricConverter srcGeoConv;
    private GeocentricConverter tgtGeoConv;

    public BasicCoordinateTransform(CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem tgtCRS) {
        this.srcCRS = srcCRS;
        this.tgtCRS = tgtCRS;
        this.doInverseProjection = srcCRS != null && srcCRS != CoordinateReferenceSystem.CS_GEO;
        this.doForwardProjection = tgtCRS != null && tgtCRS != CoordinateReferenceSystem.CS_GEO;
        boolean bl = this.doDatumTransform = this.doInverseProjection && this.doForwardProjection && srcCRS.getDatum() != tgtCRS.getDatum();
        if (this.doDatumTransform) {
            boolean isEllipsoidEqual = srcCRS.getDatum().getEllipsoid().isEqual(tgtCRS.getDatum().getEllipsoid());
            if (!isEllipsoidEqual) {
                this.transformViaGeocentric = true;
            }
            if (srcCRS.getDatum().hasTransformToWGS84() || tgtCRS.getDatum().hasTransformToWGS84()) {
                this.transformViaGeocentric = true;
            }
            if (this.transformViaGeocentric) {
                this.srcGeoConv = new GeocentricConverter(srcCRS.getDatum().getEllipsoid());
                this.tgtGeoConv = new GeocentricConverter(tgtCRS.getDatum().getEllipsoid());
            }
        }
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.srcCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.tgtCRS;
    }

    public ProjCoordinate transform(ProjCoordinate src, ProjCoordinate tgt) throws Proj4jException {
        if (this.doInverseProjection) {
            this.srcCRS.getProjection().inverseProjectRadians(src, this.geoCoord);
        } else {
            this.geoCoord.setValue(src);
        }
        if (this.doDatumTransform) {
            this.datumTransform(this.geoCoord);
        }
        if (this.doForwardProjection) {
            this.tgtCRS.getProjection().projectRadians(this.geoCoord, tgt);
        } else {
            tgt.setValue(this.geoCoord);
        }
        return tgt;
    }

    private void datumTransform(ProjCoordinate pt) {
        if (this.srcCRS.getDatum().isEqual(this.tgtCRS.getDatum())) {
            return;
        }
        if (this.transformViaGeocentric) {
            this.srcGeoConv.convertGeodeticToGeocentric(pt);
            if (this.srcCRS.getDatum().hasTransformToWGS84()) {
                this.srcCRS.getDatum().transformFromGeocentricToWgs84(pt);
            }
            if (this.tgtCRS.getDatum().hasTransformToWGS84()) {
                this.tgtCRS.getDatum().transformToGeocentricFromWgs84(pt);
            }
            this.tgtGeoConv.convertGeocentricToGeodetic(pt);
        }
    }
}

