/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import org.openstreetmap.hot.sds.SdsDiskAccessAction;
import org.openstreetmap.hot.sds.SdsWriter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public class SdsSaveAction
extends SdsDiskAccessAction {
    public SdsSaveAction() {
        super(I18n.tr((String)"Save...", (Object[])new Object[0]), "sds_save", I18n.tr((String)"Save the current separate data store information to a file.", (Object[])new Object[0]), null);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.doSave();
    }

    public boolean doSave() {
        Layer layer = null;
        if (Main.isDisplayingMapView() && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            layer = Main.map.mapView.getActiveLayer();
        }
        if (layer == null) {
            return false;
        }
        return this.doSave(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSave(Layer iLayer) {
        if (iLayer == null) {
            return false;
        }
        if (!(iLayer instanceof OsmDataLayer)) {
            return false;
        }
        OsmDataLayer layer = (OsmDataLayer)iLayer;
        File file = SdsSaveAction.createAndOpenSaveFileChooser(I18n.tr((String)"Save SDS file", (Object[])new Object[0]));
        if (file == null) {
            return false;
        }
        File tmpFile = null;
        try {
            if (file.exists()) {
                tmpFile = new File(file.getPath() + "~");
                this.copy(file, tmpFile);
            }
            FileOutputStream out = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            SdsWriter w = new SdsWriter(new PrintWriter(writer));
            layer.data.getReadLock().lock();
            try {
                w.header();
                for (OsmPrimitive p : layer.data.allNonDeletedPrimitives()) {
                    w.write((IPrimitive)p, p.getKeys());
                }
                w.footer();
                w.close();
            }
            finally {
                layer.data.getReadLock().unlock();
            }
            if (!Main.pref.getBoolean("save.keepbackup", false) && tmpFile != null) {
                tmpFile.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"<html>An error occurred while saving.<br>Error is:<br>{0}</html>", (Object[])new Object[]{e.getMessage()}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            try {
                if (tmpFile != null && tmpFile.exists()) {
                    this.copy(tmpFile, file);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"<html>An error occurred while restoring backup file.<br>Error is:<br>{0}</html>", (Object[])new Object[]{e2.getMessage()}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        }
        return true;
    }

    private void copy(File src, File dst) throws IOException {
        int len;
        FileOutputStream dstStream;
        FileInputStream srcStream;
        try {
            srcStream = new FileInputStream(src);
            dstStream = new FileOutputStream(dst);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not back up file. Exception is: {0}", (Object[])new Object[]{e.getMessage()}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            return;
        }
        byte[] buf = new byte[65536];
        while ((len = srcStream.read(buf)) != -1) {
            dstStream.write(buf, 0, len);
        }
        srcStream.close();
        dstStream.close();
    }
}

