/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.awt.Component;
import org.openstreetmap.hot.sds.SdsApi;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.tools.I18n;

public class SdsCredentialDialog
extends CredentialDialog {
    String saveUsernameAndPasswordCheckboxText;

    public static SdsCredentialDialog getSdsApiCredentialDialog(String username, String password, String host, String saveUsernameAndPasswordCheckboxText) {
        SdsCredentialDialog dialog = new SdsCredentialDialog(saveUsernameAndPasswordCheckboxText);
        dialog.prepareForSdsApiCredentials(username, password);
        dialog.pack();
        return dialog;
    }

    public SdsCredentialDialog(String saveUsernameAndPasswordCheckboxText) {
        super(saveUsernameAndPasswordCheckboxText);
    }

    public void prepareForSdsApiCredentials(String username, String password) {
        this.setTitle(I18n.tr((String)"Enter credentials for Separate Data Store API", (Object[])new Object[0]));
        this.pnlCredentials = new SdsApiCredentialsPanel(this);
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(username, password);
        this.validate();
    }

    private static class SdsApiCredentialsPanel
    extends CredentialDialog.CredentialPanel {
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr((String)"Please enter the user name of your SDS account", (Object[])new Object[0]));
            this.tfPassword.setToolTipText(I18n.tr((String)"Please enter the password of your SDS account", (Object[])new Object[0]));
            this.lblHeading.setText("<html>" + I18n.tr((String)"Authenticating at the SDS API ''{0}'' failed. Please enter a valid username and a valid password.", (Object[])new Object[]{SdsApi.getSdsApi().getBaseUrl()}) + "</html>");
            this.lblWarning.setText(I18n.tr((String)"Warning: The password is transferred unencrypted.", (Object[])new Object[0]));
        }

        public SdsApiCredentialsPanel(SdsCredentialDialog owner) {
            super((CredentialDialog)owner);
            this.build();
        }
    }
}

