/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx.data;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrack;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrackSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditGpxData {
    private final List<EditGpxTrack> tracks = new ArrayList<EditGpxTrack>();
    private final List<GpxRoute> routes = new ArrayList<GpxRoute>();
    private final List<WayPoint> waypoints = new ArrayList<WayPoint>();

    public void load(GpxData data) {
        for (GpxTrack track : data.tracks) {
            this.tracks.add(new EditGpxTrack(track));
        }
        this.routes.clear();
        this.routes.addAll(data.routes);
        this.waypoints.clear();
        this.waypoints.addAll(data.waypoints);
    }

    public boolean isEmpty() {
        for (EditGpxTrack track : this.tracks) {
            for (EditGpxTrackSegment segment : track.getSegments()) {
                if (segment.getWayPoints().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public List<EditGpxTrack> getTracks() {
        return this.tracks;
    }

    public GpxData createGpxData(boolean anonTime) {
        GpxData result = new GpxData();
        double minTime = 0.0;
        if (anonTime) {
            try {
                minTime = this.minNonDeletedTime();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        for (EditGpxTrack track : this.tracks) {
            GpxTrack newTrack;
            if (track.isDeleted() || (newTrack = track.createGpxTrack(anonTime, minTime)).getSegments().isEmpty()) continue;
            result.tracks.add(newTrack);
        }
        result.routes.addAll(this.routes);
        result.waypoints.addAll(this.waypoints);
        return result;
    }

    public double minNonDeletedTime() {
        boolean foundOne = false;
        double minTime = 0.0;
        for (EditGpxTrack track : this.tracks) {
            if (track.isDeleted()) continue;
            try {
                double t = track.minNonDeletedTime();
                if (!foundOne || t < minTime) {
                    minTime = t;
                }
                foundOne = true;
            }
            catch (NoSuchElementException e) {}
        }
        if (!foundOne) {
            throw new NoSuchElementException();
        }
        return minTime;
    }
}

