/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.customurl;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.plugins.utilsplugin2.customurl.URLList;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class UtilsPluginPreferences
extends DefaultTabPreferenceSetting {
    HistoryComboBox combo1 = new HistoryComboBox();
    JTable table;
    JButton resetButton;
    JButton loadButton;
    JButton saveButton;

    public UtilsPluginPreferences() {
        super("utils", I18n.tr((String)"Utilsplugin2 settings [TESTING]", (Object[])new Object[0]), I18n.tr((String)"Here you can change some preferences of Utilsplugin2 functions", (Object[])new Object[0]));
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel all = new JPanel(new GridBagLayout());
        String addr = URLList.getSelectedURL();
        this.table = new JTable(new DefaultTableModel((Object[][])null, new String[]{"Title", "URL"}));
        List<String> items = URLList.getURLList();
        this.resetButton = new JButton(I18n.tr((String)"Reset", (Object[])new Object[0]));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UtilsPluginPreferences.this.fillRows(URLList.resetURLList());
            }
        });
        this.saveButton = new JButton(I18n.tr((String)"Save to file", (Object[])new Object[0]));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLList.saveURLList(UtilsPluginPreferences.this.readItemsFromTable());
            }
        });
        this.loadButton = new JButton(I18n.tr((String)"Load from file", (Object[])new Object[0]));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UtilsPluginPreferences.this.fillRows(URLList.loadURLList());
            }
        });
        this.fillRows(items);
        HtmlPanel help = new HtmlPanel(I18n.tr((String)"Please edit custom URLs and select one row to use with the tool<br/> <b>&#123;key&#125;</b> is replaced with the tag value<br/> <b>&#123;#id&#125;</b> is replaced with the element ID<br/> <b>&#123;#type&#125;</b> is replaced with \"node\",\"way\" or \"relation\" <br/> <b>&#123;#lat&#125; , &#123;#lon&#125;</b> is replaced with map center latitude/longitude <br/> Your can manually load settings from file <b>customurl.txt</b> in JOSM folder", (Object[])new Object[0]));
        all.add((Component)new JLabel(I18n.tr((String)"Custom URL configuration", (Object[])new Object[0])), GBC.std().insets(5, 10, 0, 0));
        all.add((Component)this.resetButton, GBC.std().insets(25, 10, 0, 0));
        all.add((Component)this.loadButton, GBC.std().insets(25, 10, 0, 0));
        all.add((Component)this.saveButton, GBC.eol().insets(25, 10, 0, 0));
        all.add((Component)help, GBC.eop().insets(5, 10, 0, 0));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(0).setMaxWidth(300);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.setSelectionMode(0);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                DefaultTableModel model = (DefaultTableModel)e.getSource();
                if (row < 0 || column < 0) {
                    return;
                }
                String data = (String)model.getValueAt(row, column);
                if (data != null && data.length() > 0 && row == model.getRowCount() - 1) {
                    model.addRow(new String[]{"", ""});
                }
            }
        });
        all.add((Component)this.table, GBC.eop().fill());
        this.createPreferenceTabWithScrollPane(gui, all);
    }

    private void fillRows(List<String> items) {
        if (items == null) {
            return;
        }
        int p = 0;
        int row = 0;
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setRowCount(0);
        int n = items.size();
        while (p < n) {
            String name = items.get(p);
            if (++p >= n) break;
            String url = items.get(p);
            ++p;
            model.addRow(new String[]{name, url});
            ++row;
        }
        model.addRow(new String[]{"", ""});
    }

    public boolean ok() {
        String addr = this.combo1.getText();
        List<String> lst = this.readItemsFromTable();
        URLList.updateURLList(lst);
        return false;
    }

    private List<String> readItemsFromTable() {
        String v;
        TableModel model = this.table.getModel();
        ArrayList<String> lst = new ArrayList<String>();
        int n = model.getRowCount();
        for (int i = 0; i < n; ++i) {
            v = (String)model.getValueAt(i, 0);
            if (v.length() == 0) continue;
            lst.add(v);
            v = (String)model.getValueAt(i, 1);
            lst.add(v);
        }
        int row = this.table.getSelectedRow();
        if (row != -1) {
            v = (String)model.getValueAt(row, 1);
            URLList.select(v);
        }
        return lst;
    }
}

