/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectModNodesAction
extends JosmAction {
    private int lastHash;
    private Command lastCmd;

    public SelectModNodesAction() {
        super(I18n.tr((String)"Select last modified nodes", (Object[])new Object[0]), "selmodnodes", I18n.tr((String)"Select last modified nodes", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selmodnodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Select last modified nodes"}), (int)90, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectLastModifiedNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = SelectModNodesAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        SelectModNodesAction.getCurrentDataSet().clearSelection((Collection)selectedNodes);
        Command cmd = null;
        if (Main.main.undoRedo.commands == null) {
            return;
        }
        int num = Main.main.undoRedo.commands.size();
        if (num == 0) {
            return;
        }
        int k = 0;
        int idx = selection != null && !selection.isEmpty() && ((Object)selection).hashCode() == this.lastHash ? Main.main.undoRedo.commands.indexOf(this.lastCmd) : num;
        HashSet<Node> nodes = new HashSet<Node>(10);
        do {
            idx = idx > 0 ? --idx : num - 1;
            cmd = (Command)Main.main.undoRedo.commands.get(idx);
            Collection pp = cmd.getParticipatingPrimitives();
            nodes.clear();
            for (OsmPrimitive p : pp) {
                if (!(p instanceof Node) || p.isDeleted()) continue;
                nodes.add((Node)p);
            }
            if (nodes.isEmpty()) continue;
            SelectModNodesAction.getCurrentDataSet().setSelected(nodes);
            this.lastCmd = cmd;
            this.lastHash = ((Object)SelectModNodesAction.getCurrentDataSet().getSelected()).hashCode();
            return;
        } while (++k < num);
        this.lastCmd = null;
        this.lastHash = 0;
    }

    protected void updateEnabledState() {
        if (SelectModNodesAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SelectModNodesAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(true);
    }
}

