/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AlignWayNodesAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Align Way Nodes", (Object[])new Object[0]);
    private static final double MOVE_THRESHOLD = 1.0E-9;

    public AlignWayNodesAction() {
        super(TITLE, "dumbutils/alignwaynodes", I18n.tr((String)"Align nodes in a way", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:alignwaynodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Align Way Nodes", (Object[])new Object[0])}), (int)76, (int)5005), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = AlignWayNodesAction.getCurrentDataSet().getSelected();
        Set<Node> selectedNodes = this.filterNodes(selection);
        int selectedNodesCount = selectedNodes.size();
        Set<Way> ways = this.findCommonWays(selectedNodes);
        if (ways == null || ways.size() != 1 || selectedNodesCount == 0) {
            return;
        }
        Way way = ways.iterator().next();
        if (way.getNodesCount() < (way.isClosed() ? 4 : 3)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The way with selected nodes can not be straightened.", (Object[])new Object[0]), TITLE, 0);
            return;
        }
        int firstNodePos = this.findFirstNode(way, selectedNodes);
        int lastNodePos = way.isClosed() ? firstNodePos : way.getNodesCount();
        ArrayList<Node> nodes = new ArrayList<Node>();
        int i = firstNodePos;
        boolean iterated = false;
        while (!iterated || i != lastNodePos) {
            Node node = way.getNode(i);
            if (selectedNodes.contains(node)) {
                nodes.add(node);
                selectedNodes.remove(node);
                if (selectedNodesCount == 1) {
                    nodes.add(0, way.getNode(i > 0 ? i - 1 : (way.isClosed() ? way.getNodesCount() - 2 : i + 2)));
                    nodes.add(way.getNode(i + 1 < way.getNodesCount() ? i + 1 : (way.isClosed() ? 1 : i - 2)));
                }
                if (selectedNodes.isEmpty()) {
                    break;
                }
            } else if (selectedNodesCount == 2 && selectedNodes.size() == 1) {
                nodes.add(node);
            }
            if (++i >= way.getNodesCount() && way.isClosed()) {
                i = 0;
            }
            iterated = true;
        }
        if (nodes.size() < 3) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Internal error: number of nodes is {0}.", (Object[])new Object[]{nodes.size()}), TITLE, 0);
            return;
        }
        ArrayList<MoveCommand> commands = new ArrayList<MoveCommand>();
        double ax = ((Node)nodes.get(0)).getEastNorth().east();
        double ay = ((Node)nodes.get(0)).getEastNorth().north();
        double bx = ((Node)nodes.get(nodes.size() - 1)).getEastNorth().east();
        double by = ((Node)nodes.get(nodes.size() - 1)).getEastNorth().north();
        i = 1;
        while (i + 1 < nodes.size()) {
            Node n = (Node)nodes.get(i);
            double nx = n.getEastNorth().east();
            double ny = n.getEastNorth().north();
            if (ax == bx) {
                nx = ax;
            } else if (ay == by) {
                ny = ay;
            } else {
                double m1 = (by - ay) / (bx - ax);
                double c1 = ay - ax * m1;
                double m2 = -1.0 / m1;
                double c2 = ny - nx * m2;
                nx = (c2 - c1) / (m1 - m2);
                ny = m1 * nx + c1;
            }
            if (Math.abs(nx - n.getEastNorth().east()) > 1.0E-9 && Math.abs(ny - n.getEastNorth().north()) > 1.0E-9) {
                commands.add(new MoveCommand((OsmPrimitive)n, nx - n.getEastNorth().east(), ny - n.getEastNorth().north()));
            }
            ++i;
        }
        if (!commands.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(TITLE, commands));
        }
    }

    protected void updateEnabledState() {
        if (AlignWayNodesAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(AlignWayNodesAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        Set<Node> nodes = this.filterNodes(selection);
        Set<Way> ways = this.findCommonWays(nodes);
        this.setEnabled(ways != null && ways.size() == 1 && !nodes.isEmpty());
    }

    private Set<Way> findCommonWays(Set<Node> nodes) {
        HashSet ways = null;
        for (Node n : nodes) {
            List referrers = OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class);
            if (ways == null) {
                ways = new HashSet(referrers);
                continue;
            }
            ways.retainAll(referrers);
        }
        return ways;
    }

    private Set<Node> filterNodes(Collection<? extends OsmPrimitive> selection) {
        HashSet<Node> result = new HashSet<Node>();
        if (selection != null) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (!(osmPrimitive instanceof Node)) continue;
                result.add((Node)osmPrimitive);
            }
        }
        return result;
    }

    private int findFirstNode(Way way, Set<Node> nodes) {
        int pos;
        for (pos = 0; pos < way.getNodesCount() && !nodes.contains(way.getNode(pos)); ++pos) {
        }
        if (pos >= way.getNodesCount()) {
            return 0;
        }
        if (!way.isClosed() || nodes.size() <= 1) {
            return pos;
        }
        boolean fullCircle = false;
        int maxLength = 0;
        int lastPos = 0;
        while (!fullCircle) {
            int length = 0;
            boolean skippedFirst = false;
            while (!skippedFirst || !nodes.contains(way.getNode(pos))) {
                skippedFirst = true;
                ++length;
                if (++pos < way.getNodesCount()) continue;
                pos = 0;
                fullCircle = true;
            }
            if (length <= maxLength) continue;
            maxLength = length;
            lastPos = pos;
        }
        return lastPos;
    }
}

