/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class ArrayRecord
extends SharedValueRecordBase {
    public static final short sid = 545;
    private int _options;
    private int _field3notUsed;
    private Formula _formula;

    public ArrayRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this._options = recordInputStream.readUShort();
        this._field3notUsed = recordInputStream.readInt();
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.available();
        this._formula = Formula.read(n, recordInputStream, n2);
    }

    public Ptg[] getFormulaTokens() {
        return this._formula.getTokens();
    }

    @Override
    protected int getExtraDataSize() {
        return 6 + this._formula.getEncodedSize();
    }

    @Override
    protected void serializeExtraData(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._options);
        littleEndianOutput.writeInt(this._field3notUsed);
        this._formula.serialize(littleEndianOutput);
    }

    @Override
    public short getSid() {
        return 545;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" [ARRAY]\n");
        stringBuffer.append(" range=").append(this.getRange().toString()).append("\n");
        stringBuffer.append(" options=").append(HexDump.shortToHex(this._options)).append("\n");
        stringBuffer.append(" notUsed=").append(HexDump.intToHex(this._field3notUsed)).append("\n");
        stringBuffer.append(" formula:").append("\n");
        Ptg[] ptgArray = this._formula.getTokens();
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            stringBuffer.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

