/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import org.geotools.filter.capability.IdCapabilitiesImpl;
import org.geotools.filter.capability.ScalarCapabilitiesImpl;
import org.geotools.filter.capability.SpatialCapabiltiesImpl;
import org.geotools.filter.capability.TemporalCapabilitiesImpl;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.capability.IdCapabilities;
import org.opengis.filter.capability.ScalarCapabilities;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.TemporalCapabilities;

public class FilterCapabilitiesImpl
implements FilterCapabilities {
    String version;
    IdCapabilitiesImpl id;
    ScalarCapabilitiesImpl scalar;
    SpatialCapabiltiesImpl spatial;
    TemporalCapabilitiesImpl temporal;

    public FilterCapabilitiesImpl() {
        this("1.0.0");
    }

    public FilterCapabilitiesImpl(String version) {
        this.version = version;
    }

    public FilterCapabilitiesImpl(String version, ScalarCapabilities scalar, SpatialCapabilities spatial, IdCapabilities id) {
        this.version = version;
        this.id = this.toIdCapabilitiesImpl(id);
        this.scalar = this.toScalarCapabilitiesImpl(scalar);
        this.spatial = FilterCapabilitiesImpl.toSpatialCapabiltiesImpl(spatial);
        this.temporal = FilterCapabilitiesImpl.toTemporalCapabilitiesImpl(null);
    }

    public FilterCapabilitiesImpl(String version, ScalarCapabilities scalar, SpatialCapabilities spatial, IdCapabilities id, TemporalCapabilities temporal) {
        this.version = version;
        this.id = this.toIdCapabilitiesImpl(id);
        this.scalar = this.toScalarCapabilitiesImpl(scalar);
        this.spatial = FilterCapabilitiesImpl.toSpatialCapabiltiesImpl(spatial);
        this.temporal = FilterCapabilitiesImpl.toTemporalCapabilitiesImpl(temporal);
    }

    public FilterCapabilitiesImpl(FilterCapabilities copy) {
        this.version = copy.getVersion();
        this.id = copy.getIdCapabilities() == null ? null : new IdCapabilitiesImpl(copy.getIdCapabilities());
        this.scalar = this.toScalarCapabilitiesImpl(copy.getScalarCapabilities());
        this.spatial = FilterCapabilitiesImpl.toSpatialCapabiltiesImpl(copy.getSpatialCapabilities());
        this.temporal = FilterCapabilitiesImpl.toTemporalCapabilitiesImpl(copy.getTemporalCapabilities());
    }

    private ScalarCapabilitiesImpl toScalarCapabilitiesImpl(ScalarCapabilities scalarCapabilities) {
        if (scalarCapabilities == null) {
            return new ScalarCapabilitiesImpl();
        }
        if (scalarCapabilities instanceof ScalarCapabilitiesImpl) {
            return (ScalarCapabilitiesImpl)scalarCapabilities;
        }
        return new ScalarCapabilitiesImpl(scalarCapabilities);
    }

    private IdCapabilitiesImpl toIdCapabilitiesImpl(IdCapabilities idCapabilities) {
        if (idCapabilities == null) {
            return new IdCapabilitiesImpl();
        }
        if (idCapabilities instanceof IdCapabilitiesImpl) {
            return (IdCapabilitiesImpl)idCapabilities;
        }
        return new IdCapabilitiesImpl(idCapabilities);
    }

    private static SpatialCapabiltiesImpl toSpatialCapabiltiesImpl(SpatialCapabilities spatialCapabilities) {
        if (spatialCapabilities == null) {
            return new SpatialCapabiltiesImpl();
        }
        if (spatialCapabilities instanceof SpatialCapabiltiesImpl) {
            return (SpatialCapabiltiesImpl)spatialCapabilities;
        }
        return new SpatialCapabiltiesImpl(spatialCapabilities);
    }

    private static TemporalCapabilitiesImpl toTemporalCapabilitiesImpl(TemporalCapabilities temporalCapabilities) {
        if (temporalCapabilities == null) {
            return new TemporalCapabilitiesImpl();
        }
        if (temporalCapabilities instanceof TemporalCapabilitiesImpl) {
            return (TemporalCapabilitiesImpl)temporalCapabilities;
        }
        return new TemporalCapabilitiesImpl(temporalCapabilities);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setId(IdCapabilities id) {
        this.id = this.toIdCapabilitiesImpl(id);
    }

    public IdCapabilitiesImpl getIdCapabilities() {
        if (this.id == null) {
            this.id = new IdCapabilitiesImpl();
        }
        return this.id;
    }

    public void setScalar(ScalarCapabilities scalar) {
        this.scalar = this.toScalarCapabilitiesImpl(scalar);
    }

    public ScalarCapabilitiesImpl getScalarCapabilities() {
        if (this.scalar == null) {
            this.scalar = new ScalarCapabilitiesImpl();
        }
        return this.scalar;
    }

    public void setSpatial(SpatialCapabilities spatial) {
        this.spatial = FilterCapabilitiesImpl.toSpatialCapabiltiesImpl(spatial);
    }

    public SpatialCapabiltiesImpl getSpatialCapabilities() {
        if (this.spatial == null) {
            this.spatial = new SpatialCapabiltiesImpl();
        }
        return this.spatial;
    }

    public void setTemporal(TemporalCapabilitiesImpl temporal) {
        this.temporal = temporal;
    }

    public TemporalCapabilities getTemporalCapabilities() {
        return null;
    }

    public void addAll(FilterCapabilities copy) {
        this.getIdCapabilities().addAll(copy.getIdCapabilities());
        this.getScalarCapabilities().addAll(copy.getScalarCapabilities());
        this.getSpatialCapabilities().addAll(copy.getSpatialCapabilities());
        if (this.getVersion().compareTo(copy.getVersion()) < 0) {
            this.setVersion(copy.getVersion());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FilterCapabilities [");
        buf.append(this.version);
        buf.append("]");
        if (this.id != null) {
            buf.append("\n idCapabilities=");
            buf.append(this.id);
        }
        if (this.scalar != null) {
            buf.append("\n scalarCapabilities=");
            buf.append(this.scalar);
        }
        if (this.spatial != null) {
            buf.append("\n spatialCapabilities=");
            buf.append(this.spatial);
        }
        return buf.toString();
    }
}

