/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import org.geotools.io.TableWriter;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public abstract class AbstractParameter
extends Formattable
implements GeneralParameterValue,
Serializable {
    private static final long serialVersionUID = 8458179223988766398L;
    final GeneralParameterDescriptor descriptor;

    protected AbstractParameter(GeneralParameterDescriptor descriptor) {
        this.descriptor = descriptor;
        AbstractParameter.ensureNonNull("descriptor", descriptor);
    }

    public GeneralParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)name));
        }
    }

    static void ensureNonNull(String name, Object[] array, int index) throws IllegalArgumentException {
        if (array[index] == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)(name + '[' + index + ']')));
        }
    }

    static <T> void ensureValidClass(Class<?> expectedClass, Object value) throws IllegalArgumentException {
        Class<?> valueClass;
        if (value != null && !expectedClass.isAssignableFrom(valueClass = value.getClass())) {
            throw new IllegalArgumentException(Errors.format((int)61, valueClass, expectedClass));
        }
    }

    static IllegalStateException unitlessParameter(GeneralParameterDescriptor descriptor) {
        return new IllegalStateException(Errors.format((int)179, (Object)AbstractParameter.getName(descriptor)));
    }

    static String getName(GeneralParameterDescriptor descriptor) {
        return descriptor.getName().getCode();
    }

    public AbstractParameter clone() {
        try {
            return (AbstractParameter)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractParameter that = (AbstractParameter)object;
            return Utilities.equals((Object)this.descriptor, (Object)that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ 0xDC7086BE;
    }

    @Override
    public final String toString() {
        TableWriter table = new TableWriter(null, 1);
        table.setMultiLinesCells(true);
        try {
            this.write(table);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return table.toString();
    }

    protected void write(TableWriter table) throws IOException {
        table.write(AbstractParameter.getName(this.descriptor));
        table.nextColumn();
        if (this instanceof ParameterValue) {
            table.write(61);
            table.nextColumn();
            AbstractParameter.append((Writer)table, ((ParameterValue)this).getValue());
        } else if (this instanceof ParameterValueGroup) {
            table.write(58);
            table.nextColumn();
            TableWriter inner = null;
            for (GeneralParameterValue value : ((ParameterValueGroup)this).values()) {
                if (value instanceof AbstractParameter) {
                    if (inner == null) {
                        inner = new TableWriter((Writer)table, 1);
                    }
                    ((AbstractParameter)value).write(inner);
                    continue;
                }
                if (inner != null) {
                    inner.flush();
                    inner = null;
                }
                table.write(value.toString());
                table.write(System.getProperty("line.separator", "\r"));
            }
            if (inner != null) {
                inner.flush();
            }
        }
        table.nextLine();
    }

    private static void append(Writer buffer, Object value) throws IOException {
        if (value == null) {
            buffer.write("null");
        } else if (value.getClass().isArray()) {
            buffer.write(123);
            int length = Array.getLength(value);
            int limit = Math.min(5, length);
            for (int i = 0; i < limit; ++i) {
                if (i != 0) {
                    buffer.write(", ");
                }
                AbstractParameter.append(buffer, Array.get(value, i));
            }
            if (length > limit) {
                buffer.write(", ...");
            }
            buffer.write(125);
        } else {
            boolean isNumeric = value instanceof Number;
            if (!isNumeric) {
                buffer.write(34);
            }
            buffer.write(value.toString());
            if (!isNumeric) {
                buffer.write(34);
            }
        }
    }

    @Override
    protected final String formatWKT(Formatter formatter) {
        return "PARAMETER";
    }
}

