/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureReader
implements DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();

    public ReprojectFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeatureType schema, MathTransform transform) {
        this.reader = reader;
        this.schema = schema;
        this.transformer.setMathTransform((MathTransform)((MathTransform2D)transform));
    }

    public ReprojectFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, CoordinateReferenceSystem cs) throws SchemaException, OperationNotFoundException, NoSuchElementException, FactoryException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        SimpleFeatureType type = reader.getFeatureType();
        CoordinateReferenceSystem original = type.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (cs.equals(original)) {
            throw new IllegalArgumentException("CoordinateSystem " + cs + " already used (check before using wrapper)");
        }
        this.schema = FeatureTypes.transform(type, cs);
        this.reader = reader;
        this.transformer.setMathTransform(CRS.findMathTransform((CoordinateReferenceSystem)original, (CoordinateReferenceSystem)cs, (boolean)true));
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getDelegate() {
        return this.reader;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature next = this.reader.next();
        Object[] attributes = next.getAttributes().toArray();
        try {
            for (int i = 0; i < attributes.length; ++i) {
                if (!(attributes[i] instanceof Geometry)) continue;
                attributes[i] = this.transformer.transform((Geometry)attributes[i]);
            }
        }
        catch (TransformException e) {
            throw new DataSourceException("A transformation exception occurred while reprojecting data on the fly", e);
        }
        return SimpleFeatureBuilder.build(this.schema, attributes, next.getID());
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

