/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.FilteringIterator;
import org.geotools.data.store.ReTypingIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class CachingFeatureSource
implements SimpleFeatureSource {
    private SimpleFeatureSource wrapped;
    private STRtree index;
    private boolean dirty;
    private Query cachedQuery;
    private Envelope cachedBounds;
    private SimpleFeatureType cachedSchema;
    private Envelope originalBounds;
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static final Set<Class> supportedFilterTypes = new HashSet<Class>(Arrays.asList(BBOX.class, Contains.class, Crosses.class, DWithin.class, Equals.class, Intersects.class, Overlaps.class, Touches.class, Within.class));

    public CachingFeatureSource(FeatureSource original) throws IOException {
        this(DataUtilities.simple(original));
    }

    public CachingFeatureSource(SimpleFeatureSource original) throws IOException {
        this.wrapped = original;
        this.originalBounds = original.getBounds();
        if (this.originalBounds == null) {
            this.originalBounds = new Envelope(-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE);
        }
    }

    private void fillCache(Query query) throws IOException {
        DefaultQuery cloned = new DefaultQuery(query);
        cloned.getHints().remove((Object)Hints.GEOMETRY_DISTANCE);
        SimpleFeatureCollection features = this.wrapped.getFeatures(cloned);
        FeatureIterator fi = features.features();
        this.index = null;
        STRtree newIndex = new STRtree();
        while (fi.hasNext()) {
            Object f = fi.next();
            newIndex.insert((Envelope)ReferencedEnvelope.reference(f.getBounds()), f);
        }
        fi.close();
        this.index = newIndex;
        this.cachedQuery = query;
        this.cachedSchema = (SimpleFeatureType)features.getSchema();
        this.cachedBounds = this.getEnvelope(query.getFilter());
        this.dirty = false;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
        this.wrapped.addFeatureListener(listener);
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
        this.wrapped.removeFeatureListener(listener);
    }

    public DataStore getDataStore() {
        return (DataStore)this.wrapped.getDataStore();
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.wrapped.getBounds();
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.wrapped.getBounds(query);
    }

    @Override
    public int getCount(Query query) throws IOException {
        return this.wrapped.getCount(query);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.wrapped.getSchema();
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(((SimpleFeatureType)this.wrapped.getSchema()).getName().getLocalPart(), filter));
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        String schemaName = ((SimpleFeatureType)this.wrapped.getSchema()).getName().getLocalPart();
        if (query.getTypeName() != null && !schemaName.equals(query.getTypeName())) {
            throw new DataSourceException("Typename mismatch, query asks for '" + query.getTypeName() + " but this feature source provides '" + schemaName + "'");
        }
        return this.getFeatureCollection(query, this.getEnvelope(query.getFilter()));
    }

    private SimpleFeatureCollection getFeatureCollection(Query query, Envelope bounds) throws IOException {
        try {
            SimpleFeatureType base;
            SimpleFeatureType alternate = base = (SimpleFeatureType)this.wrapped.getSchema();
            if (query.getPropertyNames() != Query.ALL_NAMES && (alternate = SimpleFeatureTypeBuilder.retype(base, query.getPropertyNames())).equals(base)) {
                alternate = base;
            }
            return new CachingFeatureCollection(bounds, base, alternate, query);
        }
        catch (Exception e) {
            throw new DataSourceException("Error occurred extracting features from the spatial index", e);
        }
    }

    public static SimpleFeature reType(SimpleFeatureType featureType, SimpleFeature feature) throws IllegalAttributeException {
        SimpleFeatureType origional = feature.getFeatureType();
        if (featureType.equals(origional)) {
            return SimpleFeatureBuilder.copy(feature);
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeDescriptor curAttType = featureType.getDescriptor(i);
            attributes[i] = feature.getAttribute(curAttType.getLocalName());
        }
        return SimpleFeatureBuilder.build(featureType, attributes, id);
    }

    boolean isSubQuery(Query query) {
        Filter[] cachedFilters;
        if (this.cachedQuery == null) {
            return false;
        }
        String[] cachedPropNames = this.cachedQuery.getPropertyNames();
        String[] propNames = query.getPropertyNames();
        if (!(cachedPropNames == Query.ALL_NAMES || propNames != Query.ALL_NAMES && Arrays.asList(cachedPropNames).containsAll(Arrays.asList(propNames)))) {
            return false;
        }
        Filter[] filters = this.splitFilters(query);
        if (!filters[0].equals((cachedFilters = this.splitFilters(this.cachedQuery))[0])) {
            return false;
        }
        Envelope envelope = this.getEnvelope(filters[1]);
        return this.cachedBounds.contains(envelope);
    }

    Envelope getEnvelope(Filter filter) {
        BinarySpatialOperator gf;
        Envelope result = this.originalBounds;
        if (filter instanceof And) {
            Envelope bounds = new Envelope();
            for (Filter f : ((And)filter).getChildren()) {
                Envelope e = this.getEnvelope(f);
                if (e == null) {
                    return null;
                }
                bounds.expandToInclude(e);
            }
            result = bounds;
        } else if (filter instanceof BinarySpatialOperator && supportedFilterTypes.contains((gf = (BinarySpatialOperator)filter).getClass())) {
            Expression lg = gf.getExpression1();
            Expression rg = gf.getExpression2();
            if (lg instanceof Literal) {
                Geometry g = (Geometry)((Literal)lg).getValue();
                if (rg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            } else if (rg instanceof Literal) {
                Geometry g = (Geometry)((Literal)rg).getValue();
                if (lg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            }
        }
        return result.intersection(this.originalBounds);
    }

    Filter[] splitFilters(Query query) {
        Filter filter = query.getFilter();
        if (filter == null || filter.equals(Filter.EXCLUDE)) {
            return new Filter[]{Filter.EXCLUDE, this.bboxFilter(this.originalBounds)};
        }
        if (!(filter instanceof And)) {
            Envelope envelope = this.getEnvelope(filter);
            if (envelope == null) {
                return new Filter[]{Filter.EXCLUDE, this.bboxFilter(this.originalBounds)};
            }
            return new Filter[]{Filter.EXCLUDE, this.bboxFilter(envelope)};
        }
        And and = (And)filter;
        ArrayList<Filter> residuals = new ArrayList<Filter>();
        ArrayList<Filter> bboxBacked = new ArrayList<Filter>();
        for (Filter child : and.getChildren()) {
            if (this.getEnvelope(child) != null) {
                bboxBacked.add(child);
                continue;
            }
            residuals.add(child);
        }
        return new Filter[]{ff.and(residuals), ff.and(bboxBacked)};
    }

    private BBOX bboxFilter(Envelope bbox) {
        return ff.bbox(((SimpleFeatureType)this.wrapped.getSchema()).getGeometryDescriptor().getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
    }

    @Override
    public ResourceInfo getInfo() {
        return this.wrapped.getInfo();
    }

    @Override
    public Name getName() {
        return this.wrapped.getName();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.wrapped.getQueryCapabilities();
    }

    @Override
    public Set getSupportedHints() {
        HashSet<RenderingHints.Key> hints = new HashSet<RenderingHints.Key>(this.wrapped.getSupportedHints());
        hints.remove(Hints.FEATURE_DETACHED);
        return hints;
    }

    final class CachingFeatureCollection
    extends AbstractFeatureCollection {
        private SimpleFeatureType sourceSchema;
        private SimpleFeatureType targetSchema;
        private Query query;
        private ReferencedEnvelope queryBounds;

        protected CachingFeatureCollection(Envelope queryBounds, SimpleFeatureType sourceSchema, SimpleFeatureType targetSchema, Query query) {
            super(targetSchema);
            this.queryBounds = null;
            this.sourceSchema = sourceSchema;
            this.targetSchema = targetSchema;
            this.query = query;
        }

        @Override
        public int size() {
            try {
                return CachingFeatureSource.this.getCount(this.query);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to count features", e);
            }
        }

        @Override
        public synchronized ReferencedEnvelope getBounds() {
            try {
                return CachingFeatureSource.this.getBounds(this.query);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to count features", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Iterator openIterator() {
            List features;
            CachingFeatureSource cachingFeatureSource = CachingFeatureSource.this;
            synchronized (cachingFeatureSource) {
                try {
                    if (CachingFeatureSource.this.index == null || CachingFeatureSource.this.dirty || !CachingFeatureSource.this.isSubQuery(this.query)) {
                        CachingFeatureSource.this.fillCache(this.query);
                    }
                    features = this.queryBounds != null ? CachingFeatureSource.this.index.query((Envelope)this.queryBounds) : CachingFeatureSource.this.index.query((Envelope)CachingFeatureSource.this.index.getRoot().getBounds());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get data", e);
                }
            }
            ReTypingIterator it = features.iterator();
            if (this.query.getFilter() != null && Filter.INCLUDE.equals(this.query.getFilter())) {
                it = new FilteringIterator(it, this.query.getFilter());
            }
            if (this.targetSchema != this.sourceSchema) {
                it = new ReTypingIterator(it, this.sourceSchema, this.targetSchema);
            }
            return it;
        }

        protected void closeIterator(Iterator close) {
        }

        @Override
        public SimpleFeatureCollection subCollection(Filter filter) {
            Envelope filterEnvelope = CachingFeatureSource.this.getEnvelope(filter);
            ReferencedEnvelope subEnvelope = this.queryBounds;
            if (filterEnvelope != null) {
                subEnvelope = subEnvelope.intersection(this.queryBounds);
            }
            if (subEnvelope.isNull()) {
                return new EmptyFeatureCollection(this.targetSchema);
            }
            Query subQuery = new Query(this.query);
            Filter baseFilter = this.query.getFilter();
            if (baseFilter != null && !Filter.INCLUDE.equals(baseFilter)) {
                And mixed = ff.and(baseFilter, filter);
                subQuery.setFilter((Filter)mixed);
            }
            return new CachingFeatureCollection(subEnvelope, this.sourceSchema, this.targetSchema, subQuery);
        }
    }
}

