/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.geotools.resources.image.ImageUtilities;

public enum ViewType {
    NATIVE(false, false, false),
    PACKED(false, false, false),
    RENDERED(false, false, false),
    GEOPHYSICS(true, false, false),
    PHOTOGRAPHIC(true, true, true),
    SAME(false, false, false);

    @Deprecated
    public static final ViewType DISPLAYABLE;
    private final boolean interpolationAllowed;
    private final boolean transformOnColormapAllowed;
    private final boolean replaceIndexColorModelAllowed;

    private ViewType(boolean interpolationAllowed, boolean transformOnColormapAllowed, boolean replaceIndexColorModelAllowed) {
        this.interpolationAllowed = interpolationAllowed;
        this.transformOnColormapAllowed = transformOnColormapAllowed;
        this.replaceIndexColorModelAllowed = replaceIndexColorModelAllowed;
    }

    public boolean isInterpolationAllowed() {
        return this.interpolationAllowed;
    }

    @Deprecated
    public boolean isColorSpaceConversionAllowed() {
        return this.replaceIndexColorModelAllowed;
    }

    public boolean isReplaceIndexColorModelAllowed() {
        return this.replaceIndexColorModelAllowed;
    }

    public boolean isTransformOnColormapAllowed() {
        return this.transformOnColormapAllowed;
    }

    public RenderingHints getRenderingHints(RenderedImage image) {
        RenderingHints hints = ImageUtilities.getRenderingHints(image);
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        if (!this.isInterpolationAllowed()) {
            hints.put(JAI.KEY_INTERPOLATION, Interpolation.getInstance((int)0));
        }
        hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)this.isReplaceIndexColorModelAllowed());
        hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)this.isTransformOnColormapAllowed());
        return hints;
    }

    static {
        DISPLAYABLE = RENDERED;
    }
}

