/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StorageFile;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class ShapefileFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    protected FeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
    protected ShapefileAttributeReader attReader;
    protected SimpleFeature currentFeature;
    protected SimpleFeatureType featureType;
    protected Object[] emptyAtts;
    protected Object[] transferCache;
    protected ShapeType shapeType;
    protected ShapeHandler handler;
    protected int shapefileLength = 100;
    protected int records = 0;
    protected byte[] writeFlags;
    protected ShapefileWriter shpWriter;
    protected DbaseFileWriter dbfWriter;
    private DbaseFileHeader dbfHeader;
    protected Map<ShpFileType, StorageFile> storageFiles = new HashMap<ShpFileType, StorageFile>();
    protected Envelope bounds = new Envelope();
    protected ShpFiles shpFiles;
    private FileChannel dbfChannel;
    private Charset dbfCharset;
    private TimeZone dbfTimeZone;
    private GeometryFactory gf = new GeometryFactory();

    public ShapefileFeatureWriter(String typeName, ShpFiles shpFiles, ShapefileAttributeReader attsReader, FeatureReader<SimpleFeatureType, SimpleFeature> featureReader, Charset charset, TimeZone timezone) throws IOException {
        this.shpFiles = shpFiles;
        this.dbfCharset = charset;
        this.dbfTimeZone = timezone;
        this.attReader = attsReader;
        this.featureReader = featureReader;
        this.storageFiles.put(ShpFileType.SHP, shpFiles.getStorageFile(ShpFileType.SHP));
        this.storageFiles.put(ShpFileType.SHX, shpFiles.getStorageFile(ShpFileType.SHX));
        this.storageFiles.put(ShpFileType.DBF, shpFiles.getStorageFile(ShpFileType.DBF));
        this.featureType = featureReader.getFeatureType();
        this.emptyAtts = new Object[this.featureType.getAttributeCount()];
        this.writeFlags = new byte[this.featureType.getAttributeCount()];
        int cnt = 0;
        int ii = this.featureType.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            if (this.featureType.getDescriptor(i) instanceof GeometryDescriptor) continue;
            ++cnt;
            this.writeFlags[i] = 1;
        }
        this.transferCache = new Object[cnt];
        FileChannel shpChannel = this.storageFiles.get((Object)ShpFileType.SHP).getWriteChannel();
        FileChannel shxChannel = this.storageFiles.get((Object)ShpFileType.SHX).getWriteChannel();
        this.shpWriter = new ShapefileWriter(shpChannel, shxChannel);
        this.dbfHeader = ShapefileDataStore.createDbaseHeader(this.featureType);
        this.dbfChannel = this.storageFiles.get((Object)ShpFileType.DBF).getWriteChannel();
        this.dbfWriter = new DbaseFileWriter(this.dbfHeader, this.dbfChannel, this.dbfCharset, this.dbfTimeZone);
        if (this.attReader != null) {
            this.attReader.shp.disableShxUsage();
            if (this.attReader.hasNext()) {
                this.shapeType = this.attReader.shp.getHeader().getShapeType();
                this.handler = this.shapeType.getShapeHandler(new GeometryFactory());
                this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
            }
        }
    }

    protected void flush() throws IOException {
        if (this.records <= 0 && this.shapeType == null) {
            GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
            this.shapeType = JTSUtilities.getShapeType(geometryDescriptor);
        }
        this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
        this.dbfHeader.setNumRecords(this.records);
        this.dbfChannel.position(0L);
        this.dbfHeader.writeHeader(this.dbfChannel);
    }

    protected void finalize() throws Throwable {
        if (this.featureReader != null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void clean() throws IOException {
        StorageFile.replaceOriginals(this.storageFiles.values().toArray(new StorageFile[0]));
    }

    @Override
    public void close() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        if (this.attReader != null && this.attReader.internalReadersHaveNext()) {
            this.shapeType = this.attReader.shp.getHeader().getShapeType();
            this.handler = this.shapeType.getShapeHandler(this.gf);
            if (this.records == 0) {
                this.shpWriter.writeHeaders(this.bounds, this.shapeType, 0, 0);
            }
            double[] env = new double[4];
            while (this.attReader.internalReadersHaveNext()) {
                this.shapefileLength += this.attReader.shp.transferTo(this.shpWriter, ++this.records, env);
                this.bounds.expandToInclude(env[0], env[1]);
                this.bounds.expandToInclude(env[2], env[3]);
                this.attReader.dbf.transferTo(this.dbfWriter);
            }
        }
        this.doClose();
        this.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        try {
            this.featureReader.close();
        }
        finally {
            try {
                this.flush();
            }
            finally {
                this.shpWriter.close();
                this.dbfWriter.close();
            }
            this.featureReader = null;
            this.shpWriter = null;
            this.dbfWriter = null;
        }
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        return this.featureReader.hasNext();
    }

    @Override
    public SimpleFeature next() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        if (this.featureReader.hasNext()) {
            try {
                this.currentFeature = this.featureReader.next();
                return this.currentFeature;
            }
            catch (IllegalAttributeException iae) {
                throw new DataSourceException("Error in reading", (Throwable)((Object)iae));
            }
        }
        try {
            String featureID = this.getFeatureType().getTypeName() + "." + (this.records + 1);
            this.currentFeature = DataUtilities.template(this.getFeatureType(), featureID, this.emptyAtts);
            return this.currentFeature;
        }
        catch (IllegalAttributeException iae) {
            throw new DataSourceException("Error creating empty Feature", (Throwable)((Object)iae));
        }
    }

    protected String nextFeatureId() {
        return this.getFeatureType().getTypeName() + "." + (this.records + 1);
    }

    @Override
    public void remove() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        if (this.currentFeature == null) {
            throw new IOException("Current feature is null");
        }
        this.currentFeature = null;
    }

    @Override
    public void write() throws IOException {
        Envelope b;
        if (this.currentFeature == null) {
            throw new IOException("Current feature is null");
        }
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        Geometry g = (Geometry)this.currentFeature.getDefaultGeometry();
        if (this.shapeType == null) {
            try {
                if (g != null) {
                    int dims = JTSUtilities.guessCoorinateDims(g.getCoordinates());
                    this.shapeType = JTSUtilities.getShapeType(g, dims);
                } else {
                    this.shapeType = JTSUtilities.getShapeType(this.currentFeature.getType().getGeometryDescriptor());
                }
                this.shpWriter.writeHeaders(new Envelope(), this.shapeType, 0, 0);
                this.handler = this.shapeType.getShapeHandler(this.gf);
            }
            catch (ShapefileException se) {
                throw new RuntimeException("Unexpected Error", se);
            }
        }
        if ((g = JTSUtilities.convertToCollection(g, this.shapeType)) != null && !(b = g.getEnvelopeInternal()).isNull()) {
            this.bounds.expandToInclude(b);
        }
        this.shapefileLength = g != null ? (this.shapefileLength += this.handler.getLength(g) + 8) : (this.shapefileLength += 12);
        this.shpWriter.writeGeometry(g);
        int idx = 0;
        int ii = this.featureType.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            if (this.writeFlags[i] <= 0) continue;
            this.transferCache[idx++] = this.currentFeature.getAttribute(i);
        }
        this.dbfWriter.write(this.transferCache);
        ++this.records;
        this.currentFeature = null;
    }
}

