/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.vecmath.GMatrix;
import org.geotools.io.ContentFormatException;
import org.geotools.io.LineFormat;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.Matrix;

public class GeneralMatrix
extends GMatrix
implements XMatrix {
    private static final long serialVersionUID = 8447482612423035360L;

    public GeneralMatrix(int size) {
        super(size, size);
    }

    public GeneralMatrix(int numRow, int numCol) {
        super(numRow, numCol);
    }

    public GeneralMatrix(int numRow, int numCol, double[] matrix) {
        super(numRow, numCol, matrix);
        if (numRow * numCol != matrix.length) {
            throw new IllegalArgumentException(String.valueOf(matrix.length));
        }
    }

    public GeneralMatrix(double[][] matrix) throws IllegalArgumentException {
        super(matrix.length, matrix.length != 0 ? matrix[0].length : 0);
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        for (int j = 0; j < numRow; ++j) {
            if (matrix[j].length != numCol) {
                throw new IllegalArgumentException(Errors.format(90));
            }
            this.setRow(j, matrix[j]);
        }
    }

    public GeneralMatrix(Matrix matrix) {
        this(matrix.getNumRow(), matrix.getNumCol());
        int height = this.getNumRow();
        int width = this.getNumCol();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    public GeneralMatrix(GMatrix matrix) {
        super(matrix);
    }

    public GeneralMatrix(AffineTransform transform) {
        super(3, 3, new double[]{transform.getScaleX(), transform.getShearX(), transform.getTranslateX(), transform.getShearY(), transform.getScaleY(), transform.getTranslateY(), 0.0, 0.0, 1.0});
        assert (this.isAffine()) : this;
    }

    public GeneralMatrix(Envelope srcRegion, Envelope dstRegion) {
        super(dstRegion.getDimension() + 1, srcRegion.getDimension() + 1);
        int srcDim = srcRegion.getDimension();
        int dstDim = dstRegion.getDimension();
        int i = Math.min(srcDim, dstDim);
        while (--i >= 0) {
            double scale = dstRegion.getSpan(i) / srcRegion.getSpan(i);
            double translate = dstRegion.getMinimum(i) - srcRegion.getMinimum(i) * scale;
            this.setElement(i, i, scale);
            this.setElement(i, srcDim, translate);
        }
        this.setElement(dstDim, srcDim, 1.0);
        assert (srcDim != dstDim || this.isAffine()) : this;
    }

    public GeneralMatrix(AxisDirection[] srcAxis, AxisDirection[] dstAxis) {
        this(null, srcAxis, null, dstAxis, false);
    }

    public GeneralMatrix(Envelope srcRegion, AxisDirection[] srcAxis, Envelope dstRegion, AxisDirection[] dstAxis) {
        this(srcRegion, srcAxis, dstRegion, dstAxis, true);
    }

    private GeneralMatrix(Envelope srcRegion, AxisDirection[] srcAxis, Envelope dstRegion, AxisDirection[] dstAxis, boolean validRegions) {
        super(dstAxis.length + 1, srcAxis.length + 1);
        if (validRegions) {
            GeneralMatrix.ensureDimensionMatch("srcRegion", srcRegion, srcAxis.length);
            GeneralMatrix.ensureDimensionMatch("dstRegion", dstRegion, dstAxis.length);
        }
        this.setZero();
        for (int dstIndex = 0; dstIndex < dstAxis.length; ++dstIndex) {
            boolean hasFound = false;
            AxisDirection dstAxe = dstAxis[dstIndex];
            AxisDirection search = dstAxe.absolute();
            for (int srcIndex = 0; srcIndex < srcAxis.length; ++srcIndex) {
                AxisDirection srcAxe = srcAxis[srcIndex];
                if (!search.equals(srcAxe.absolute())) continue;
                if (hasFound) {
                    throw new IllegalArgumentException(Errors.format(36, srcAxe.name(), dstAxe.name()));
                }
                hasFound = true;
                boolean normal = srcAxe.equals(dstAxe);
                double scale = normal ? 1.0 : -1.0;
                double translate = 0.0;
                if (validRegions) {
                    translate = normal ? dstRegion.getMinimum(dstIndex) : dstRegion.getMaximum(dstIndex);
                    translate -= srcRegion.getMinimum(srcIndex) * (scale *= dstRegion.getSpan(dstIndex) / srcRegion.getSpan(srcIndex));
                }
                this.setElement(dstIndex, srcIndex, scale);
                this.setElement(dstIndex, srcAxis.length, translate);
            }
            if (hasFound) continue;
            throw new IllegalArgumentException(Errors.format(136, dstAxis[dstIndex].name()));
        }
        this.setElement(dstAxis.length, srcAxis.length, 1.0);
        assert (srcAxis.length != dstAxis.length || this.isAffine()) : this;
    }

    private static void ensureDimensionMatch(String name, Envelope envelope, int dimension) throws MismatchedDimensionException {
        int dim = envelope.getDimension();
        if (dimension != dim) {
            throw new MismatchedDimensionException(Errors.format(94, name, dim, dimension));
        }
    }

    public static double[][] getElements(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return ((GeneralMatrix)matrix).getElements();
        }
        int numCol = matrix.getNumCol();
        double[][] rows = new double[matrix.getNumRow()][];
        for (int j = 0; j < rows.length; ++j) {
            double[] row = new double[numCol];
            rows[j] = row;
            for (int i = 0; i < row.length; ++i) {
                row[i] = matrix.getElement(j, i);
            }
        }
        return rows;
    }

    public final double[][] getElements() {
        int numCol = this.getNumCol();
        double[][] rows = new double[this.getNumRow()][];
        for (int j = 0; j < rows.length; ++j) {
            rows[j] = new double[numCol];
            this.getRow(j, rows[j]);
        }
        return rows;
    }

    @Override
    public final boolean isAffine() {
        int dimension = this.getNumRow();
        if (dimension != this.getNumCol()) {
            return false;
        }
        --dimension;
        for (int i = 0; i <= dimension; ++i) {
            if (this.getElement(dimension, i) == (double)(i == dimension ? 1 : 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isIdentity() {
        int numCol;
        int numRow = this.getNumRow();
        if (numRow != (numCol = this.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                if (this.getElement(j, i) == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        assert (this.isAffine()) : this;
        assert (this.isIdentity(0.0)) : this;
        return true;
    }

    @Override
    public final boolean isIdentity(double tolerance) {
        return GeneralMatrix.isIdentity(this, tolerance);
    }

    static boolean isIdentity(Matrix matrix, double tolerance) {
        int numCol;
        tolerance = Math.abs(tolerance);
        int numRow = matrix.getNumRow();
        if (numRow != (numCol = matrix.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                double e = matrix.getElement(j, i);
                if (i == j) {
                    e -= 1.0;
                }
                if (Math.abs(e) <= tolerance) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void multiply(Matrix matrix) {
        GMatrix m = matrix instanceof GMatrix ? (GMatrix)((Object)matrix) : new GeneralMatrix(matrix);
        this.mul(m);
    }

    @Override
    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    static boolean epsilonEquals(Matrix m1, Matrix m2, double tolerance) {
        int numRow = m1.getNumRow();
        if (numRow != m2.getNumRow()) {
            return false;
        }
        int numCol = m1.getNumCol();
        if (numCol != m2.getNumCol()) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                double v2;
                double v1 = m1.getElement(j, i);
                if (Math.abs(v1 - (v2 = m2.getElement(j, i))) <= tolerance || Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2)) continue;
                return false;
            }
        }
        return true;
    }

    public final AffineTransform toAffineTransform2D() throws IllegalStateException {
        int check = this.getNumRow();
        if (check != 3 || (check = this.getNumCol()) != 3) {
            throw new IllegalStateException(Errors.format(127, check - 1));
        }
        if (this.isAffine()) {
            return new AffineTransform(this.getElement(0, 0), this.getElement(1, 0), this.getElement(0, 1), this.getElement(1, 1), this.getElement(0, 2), this.getElement(1, 2));
        }
        throw new IllegalStateException(Errors.format(118));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralMatrix load(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            GeneralMatrix generalMatrix = GeneralMatrix.load(in, Locale.US);
            return generalMatrix;
        }
        finally {
            in.close();
        }
    }

    public static GeneralMatrix load(BufferedReader in, Locale locale) throws IOException {
        String line;
        LineFormat parser = new LineFormat(locale);
        double[] data = null;
        double[] row = null;
        int numRow = 0;
        int numData = 0;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0) {
                if (numRow != 0) break;
                continue;
            }
            try {
                parser.setLine(line);
                row = parser.getValues(row);
            }
            catch (ParseException exception) {
                throw new ContentFormatException(exception.getLocalizedMessage(), exception);
            }
            int upper = numData + row.length;
            if (data == null) {
                data = new double[numData * numData];
            }
            if (upper > data.length) {
                data = XArray.resize(data, upper * 2);
            }
            System.arraycopy(row, 0, data, numData, row.length);
            numData = upper;
            assert (numData % ++numRow == 0) : numData;
        }
        data = data != null ? XArray.resize(data, numData) : new double[]{};
        return new GeneralMatrix(numRow, numData / numRow, data);
    }

    @Override
    public String toString() {
        return GeneralMatrix.toString(this);
    }

    static String toString(Matrix matrix) {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        StringBuffer buffer = new StringBuffer();
        int columnWidth = 12;
        String lineSeparator = System.getProperty("line.separator", "\n");
        FieldPosition dummy = new FieldPosition(0);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setGroupingUsed(false);
        format.setMinimumFractionDigits(6);
        format.setMaximumFractionDigits(6);
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                int position = buffer.length();
                buffer = format.format(matrix.getElement(j, i), buffer, dummy);
                int spaces = Math.max(12 - (buffer.length() - position), 1);
                buffer.insert(position, Utilities.spaces(spaces));
            }
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    @Override
    public GeneralMatrix clone() {
        return (GeneralMatrix)super.clone();
    }
}

