/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index;

import org.geotools.index.Lock;
import org.geotools.index.LockTimeoutException;

public class LockManager {
    private static final int EXCLUSIVE_LOCK_TIMEOUT = 20;
    private static final int SHARED_LOCK_TIMEOUT = 10;
    public static final short READ = 1;
    public static final short WRITE = 2;
    private Lock exclusiveLock;
    private int leases;

    public synchronized void release(Lock lock) {
        LockImpl li = (LockImpl)lock;
        if (li.getType() == 2) {
            this.exclusiveLock = null;
        } else {
            --this.leases;
        }
        this.notify();
    }

    public synchronized Lock aquireExclusive() throws LockTimeoutException {
        for (int cnt = 0; (this.exclusiveLock != null || this.leases > 0) && cnt < 20; ++cnt) {
            try {
                this.wait(500L);
                continue;
            }
            catch (InterruptedException e) {
                throw new LockTimeoutException(e);
            }
        }
        if (this.exclusiveLock != null || this.leases > 0) {
            throw new LockTimeoutException("Timeout aquiring exclusive lock");
        }
        this.exclusiveLock = new LockImpl(2);
        return this.exclusiveLock;
    }

    public synchronized Lock aquireShared() throws LockTimeoutException {
        for (int cnt = 0; this.exclusiveLock != null && cnt < 10; ++cnt) {
            try {
                this.wait(500L);
                continue;
            }
            catch (InterruptedException e) {
                throw new LockTimeoutException(e);
            }
        }
        if (this.exclusiveLock != null) {
            throw new LockTimeoutException("Timeout aquiring shared lock");
        }
        ++this.leases;
        return new LockImpl(1);
    }

    private class LockImpl
    implements Lock {
        private short type;

        public LockImpl(short type) {
            this.type = type;
        }

        @Override
        public short getType() {
            return this.type;
        }
    }
}

