/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.NationalHandlers;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.tools.I18n;

public class ShpReader
extends GeographicReader {
    private final ShpHandler handler;
    private final Set<OsmPrimitive> featurePrimitives = new HashSet<OsmPrimitive>();

    public ShpReader(ShpHandler handler) {
        super(handler, NationalHandlers.DEFAULT_SHP_HANDLERS);
        this.handler = handler;
    }

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new ShpReader(handler != null ? handler.getShpHandler() : null).parse(file, instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private void parseFeature(Feature feature, Component parent) throws UserCancelException, GeoMathTransformException, FactoryException, GeoCrsException, MismatchedDimensionException, TransformException {
        this.featurePrimitives.clear();
        GeometryAttribute geometry = feature.getDefaultGeometryProperty();
        if (geometry != null) {
            GeometryDescriptor desc = geometry.getDescriptor();
            if (this.crs == null && desc != null && desc.getCoordinateReferenceSystem() != null) {
                this.crs = desc.getCoordinateReferenceSystem();
                this.findMathTransform(parent, true);
            } else if (this.crs == null) {
                throw new GeoCrsException("Unable to detect CRS !");
            }
            Node primitive = null;
            if (geometry.getValue() instanceof Point) {
                primitive = this.createOrGetNode((Point)geometry.getValue());
            } else if (geometry.getValue() instanceof GeometryCollection) {
                GeometryCollection mp = (GeometryCollection)geometry.getValue();
                int nGeometries = mp.getNumGeometries();
                if (nGeometries < 1) {
                    System.err.println("Error: empty geometry collection found");
                } else {
                    Way r = null;
                    Way w = null;
                    for (int i = 0; i < nGeometries; ++i) {
                        Geometry g = mp.getGeometryN(i);
                        if (g instanceof Polygon) {
                            Polygon p = (Polygon)g;
                            if (r == null && (nGeometries > 1 || p.getNumInteriorRing() > 0 || this.handler != null && this.handler.preferMultipolygonToSimpleWay())) {
                                r = this.createMultipolygon();
                            }
                            w = this.createWay(p.getExteriorRing());
                            if (r == null) continue;
                            this.addWayToMp((Relation)r, "outer", w);
                            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                                this.addWayToMp((Relation)r, "inner", this.createWay(p.getInteriorRingN(j)));
                            }
                            continue;
                        }
                        if (g instanceof LineString) {
                            w = this.createWay((LineString)g);
                            continue;
                        }
                        if (g instanceof Point) {
                            ShpReader.readNonGeometricAttributes(feature, (OsmPrimitive)this.createOrGetNode((Point)g));
                            continue;
                        }
                        System.err.println("Error: unsupported geometry : " + g);
                    }
                    primitive = r != null ? r : w;
                }
            } else {
                System.out.println("\ttype: " + geometry.getType());
                System.out.println("\tbounds: " + geometry.getBounds());
                System.out.println("\tdescriptor: " + desc);
                System.out.println("\tname: " + geometry.getName());
                System.out.println("\tvalue: " + geometry.getValue());
                System.out.println("\tid: " + geometry.getIdentifier());
                System.out.println("-------------------------------------------------------------");
            }
            if (primitive != null) {
                ShpReader.readNonGeometricAttributes(feature, (OsmPrimitive)primitive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet parse(File file, ProgressMonitor instance) throws IOException {
        this.crs = null;
        this.transform = null;
        try {
            DataStore dataStore;
            if (file == null) return this.ds;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            if (this.handler != null && this.handler.getDbfCharset() != null) {
                params.put(ShapefileDataStoreFactory.DBFCHARSET.key, this.handler.getDbfCharset());
            }
            if ((dataStore = new ShapefileDataStoreFactory().createDataStore(params)) == null) {
                throw new IOException(I18n.tr((String)"Unable to find a data store for file {0}", (Object[])new Object[]{file.getName()}));
            }
            String[] typeNames = dataStore.getTypeNames();
            String typeName = typeNames[0];
            SimpleFeatureSource featureSource = dataStore.getFeatureSource(typeName);
            FeatureCollection collection = featureSource.getFeatures();
            FeatureIterator iterator = collection.features();
            if (instance != null) {
                instance.beginTask(I18n.tr((String)"Loading shapefile ({0} features)", (Object[])new Object[]{collection.size()}), collection.size());
            }
            int n = 0;
            Component parent = instance != null ? instance.getWindowParent() : Main.parent;
            try {
                while (iterator.hasNext()) {
                    ++n;
                    try {
                        Feature feature = iterator.next();
                        this.parseFeature(feature, parent);
                        if (this.handler != null) {
                            this.handler.notifyFeatureParsed(feature, this.ds, this.featurePrimitives);
                        }
                    }
                    catch (UserCancelException e) {
                        DataSet dataSet = this.ds;
                        iterator.close();
                        this.nodes.clear();
                        if (instance == null) return dataSet;
                        instance.setCustomText(null);
                        return dataSet;
                    }
                    if (instance == null) continue;
                    instance.worked(1);
                    instance.setCustomText(n + "/" + collection.size());
                }
                return this.ds;
            }
            finally {
                iterator.close();
                this.nodes.clear();
                if (instance != null) {
                    instance.setCustomText(null);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static final void readNonGeometricAttributes(Feature feature, OsmPrimitive primitive) {
        for (Property prop : feature.getProperties()) {
            if (prop instanceof GeometryAttribute) continue;
            Name name = prop.getName();
            Object value = prop.getValue();
            if (name == null || value == null) continue;
            String sName = name.toString();
            String sValue = value.toString();
            if (sName.isEmpty() || sValue.isEmpty()) continue;
            primitive.put(sName, sValue);
        }
    }

    @Override
    protected Node createOrGetNode(Point p) throws MismatchedDimensionException, TransformException {
        Node n = super.createOrGetNode(p);
        this.featurePrimitives.add((OsmPrimitive)n);
        return n;
    }

    @Override
    protected <T extends OsmPrimitive> T addOsmPrimitive(T p) {
        this.featurePrimitives.add(p);
        return super.addOsmPrimitive(p);
    }
}

