/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.AbstractMapInfoReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifDatum;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifProjection;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;

public class MifReader
extends AbstractMapInfoReader {
    protected BufferedReader midReader;
    private Character delimiter = Character.valueOf('\t');
    private State state = State.UNKNOWN;
    private Projection josmProj;
    private DataSet ds;
    private Relation region;
    private Way polygon;
    private Node node;
    private Way polyline;
    private MifProjection proj;
    private MifDatum datum;
    private String units;
    private Double originLon;
    private Double originLat;
    private Double stdP1;
    private Double stdP2;
    private Double azimuth;
    private Double scaleFactor;
    private Double falseEasting;
    private Double falseNorthing;
    private Double range;
    private int numpolygons = -1;
    private int numpts = -1;

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        return new MifReader().parse(in, file, instance, Charset.forName("ISO-8859-15"));
    }

    private void parseDelimiter(String[] words) {
        this.delimiter = Character.valueOf(words[1].charAt(1));
    }

    private void parseUnique(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private void parseIndex(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private void parseCoordSys(String[] words) {
        block41: {
            block40: {
                int offset;
                for (int i = 0; i < words.length; ++i) {
                    words[i] = words[i].replace(",", "");
                }
                if (!words[1].equalsIgnoreCase("Earth")) break block40;
                this.proj = MifProjection.forCode(Integer.parseInt(words[3]));
                this.datum = MifDatum.forCode(Integer.parseInt(words[4]));
                int n = offset = this.datum == MifDatum.Custom ? 4 : 0;
                if (this.proj == MifProjection.Longitude_Latitude) {
                    this.josmProj = Projections.getProjectionByCode((String)"EPSG:4326");
                    return;
                }
                this.units = words[5 + offset];
                this.originLon = Double.parseDouble(words[6 + offset]);
                switch (this.proj) {
                    case Albers_Equal_Area_Conic: 
                    case Azimuthal_Equidistant_polar_aspect_only: 
                    case Equidistant_Conic_also_known_as_Simple_Conic: 
                    case Hotine_Oblique_Mercator: 
                    case Lambert_Azimuthal_Equal_Area_polar_aspect_only: 
                    case Lambert_Conformal_Conic: 
                    case Lambert_Conformal_Conic_modified_for_Belgium_1972: 
                    case New_Zealand_Map_Grid: 
                    case Stereographic: 
                    case Swiss_Oblique_Mercator: 
                    case Transverse_Mercator_also_known_as_Gauss_Kruger: 
                    case Transverse_Mercator_modified_for_Danish_System_34_Jylland_Fyn: 
                    case Transverse_Mercator_modified_for_Danish_System_45_Bornholm: 
                    case Transverse_Mercator_modified_for_Finnish_KKJ: 
                    case Transverse_Mercator_modified_for_Sjaelland: 
                    case Polyconic: {
                        this.originLat = Double.parseDouble(words[7 + offset]);
                    }
                }
                switch (this.proj) {
                    case Cylindrical_Equal_Area: 
                    case Regional_Mercator: {
                        this.stdP1 = Double.parseDouble(words[7 + offset]);
                        break;
                    }
                    case Albers_Equal_Area_Conic: 
                    case Equidistant_Conic_also_known_as_Simple_Conic: 
                    case Lambert_Conformal_Conic: 
                    case Lambert_Conformal_Conic_modified_for_Belgium_1972: {
                        this.stdP1 = Double.parseDouble(words[8 + offset]);
                    }
                }
                switch (this.proj) {
                    case Albers_Equal_Area_Conic: 
                    case Equidistant_Conic_also_known_as_Simple_Conic: 
                    case Lambert_Conformal_Conic: 
                    case Lambert_Conformal_Conic_modified_for_Belgium_1972: {
                        this.stdP2 = Double.parseDouble(words[9 + offset]);
                    }
                }
                if (this.proj == MifProjection.Hotine_Oblique_Mercator) {
                    this.azimuth = Double.parseDouble(words[8 + offset]);
                }
                switch (this.proj) {
                    case Hotine_Oblique_Mercator: {
                        this.scaleFactor = Double.parseDouble(words[9 + offset]);
                        break;
                    }
                    case Stereographic: 
                    case Transverse_Mercator_also_known_as_Gauss_Kruger: 
                    case Transverse_Mercator_modified_for_Danish_System_34_Jylland_Fyn: 
                    case Transverse_Mercator_modified_for_Danish_System_45_Bornholm: 
                    case Transverse_Mercator_modified_for_Finnish_KKJ: 
                    case Transverse_Mercator_modified_for_Sjaelland: {
                        this.scaleFactor = Double.parseDouble(words[8 + offset]);
                    }
                }
                switch (this.proj) {
                    case Albers_Equal_Area_Conic: 
                    case Equidistant_Conic_also_known_as_Simple_Conic: 
                    case Hotine_Oblique_Mercator: 
                    case Lambert_Conformal_Conic: 
                    case Lambert_Conformal_Conic_modified_for_Belgium_1972: {
                        this.falseEasting = Double.parseDouble(words[10 + offset]);
                        this.falseNorthing = Double.parseDouble(words[11 + offset]);
                        break;
                    }
                    case Stereographic: 
                    case Transverse_Mercator_also_known_as_Gauss_Kruger: 
                    case Transverse_Mercator_modified_for_Danish_System_34_Jylland_Fyn: 
                    case Transverse_Mercator_modified_for_Danish_System_45_Bornholm: 
                    case Transverse_Mercator_modified_for_Finnish_KKJ: 
                    case Transverse_Mercator_modified_for_Sjaelland: {
                        this.falseEasting = Double.parseDouble(words[9 + offset]);
                        this.falseNorthing = Double.parseDouble(words[10 + offset]);
                        break;
                    }
                    case New_Zealand_Map_Grid: 
                    case Swiss_Oblique_Mercator: 
                    case Polyconic: {
                        this.falseEasting = Double.parseDouble(words[8 + offset]);
                        this.falseNorthing = Double.parseDouble(words[9 + offset]);
                    }
                }
                switch (this.proj) {
                    case Azimuthal_Equidistant_polar_aspect_only: 
                    case Lambert_Azimuthal_Equal_Area_polar_aspect_only: {
                        this.range = Double.parseDouble(words[8 + offset]);
                    }
                }
                switch (this.proj) {
                    case Lambert_Conformal_Conic: {
                        if ((this.datum == MifDatum.Geodetic_Reference_System_1980_GRS_80 || this.datum == MifDatum.Custom) && MifReader.equals(this.originLon, 3.0)) {
                            if (MifReader.equals(this.originLat, 46.5) && MifReader.equals(this.stdP1, 44.0) && MifReader.equals(this.stdP2, 49.0) && MifReader.equals(this.falseEasting, 700000.0) && MifReader.equals(this.falseNorthing, 6600000.0)) {
                                this.josmProj = Projections.getProjectionByCode((String)"EPSG:2154");
                                break;
                            }
                            if (MifReader.equals(this.falseEasting, 1700000.0)) {
                                for (int i = 0; this.josmProj == null && i < 9; ++i) {
                                    if (!MifReader.equals(this.originLat, 42.0 + (double)i) || !MifReader.equals(this.stdP1, 41.25 + (double)i) || !MifReader.equals(this.stdP2, 42.75 + (double)i) || !MifReader.equals(this.falseNorthing, (double)(i + 1) * 1000000.0 + 200000.0)) continue;
                                    this.josmProj = Projections.getProjectionByCode((String)("EPSG:" + Integer.toString(3942 + i)));
                                }
                            }
                        }
                        break block41;
                    }
                    default: {
                        System.err.println("TODO: " + this.line);
                    }
                }
                break block41;
            }
            if (words[1].equalsIgnoreCase("Nonearth")) {
                System.err.println("TODO: " + this.line);
            } else if (words[1].equalsIgnoreCase("Layout")) {
                System.err.println("TODO: " + this.line);
            } else if (words[1].equalsIgnoreCase("Table")) {
                System.err.println("TODO: " + this.line);
            } else if (words[1].equalsIgnoreCase("Window")) {
                System.err.println("TODO: " + this.line);
            } else {
                System.err.println("Line " + this.lineNum + ". Invalid CoordSys clause: " + this.line);
            }
        }
    }

    private void parseTransform(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    @Override
    protected void parseColumns(String[] words) {
        super.parseColumns(words);
        this.state = State.READING_COLUMNS;
    }

    private void parseData(String[] words) {
        if (this.ds == null) {
            this.ds = new DataSet();
        }
    }

    private void parsePoint(String[] words) throws IOException {
        this.readAttributes((OsmPrimitive)this.createNode(words[1], words[2]));
    }

    private void parseLine(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private void parsePLine(String[] words) throws IOException {
        if (words.length > 2) {
            this.polyline = new Way();
            this.ds.addPrimitive((OsmPrimitive)this.polyline);
            this.readAttributes((OsmPrimitive)this.polyline);
            this.numpts = Integer.parseInt(words[1]);
            this.state = State.READING_POINTS;
        } else {
            this.numpts = -1;
            this.state = State.START_POLYLINE;
        }
    }

    private void parseRegion(String[] words) throws IOException {
        this.region = new Relation();
        this.region.put("type", "multipolygon");
        this.ds.addPrimitive((OsmPrimitive)this.region);
        this.readAttributes((OsmPrimitive)this.region);
        this.numpolygons = Integer.parseInt(words[1]);
        this.state = State.START_POLYGON;
    }

    private void parseArc(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private void parseText(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private void parseRect(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private void parseRoundRect(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private void parseEllipse(String[] words) {
        System.err.println("TODO: " + this.line);
    }

    private DataSet parse(InputStream in, File file, ProgressMonitor instance, Charset charset) throws IOException {
        try {
            this.headerReader = new BufferedReader(new InputStreamReader(in, charset));
            this.midReader = this.getDataReader(file, ".mid", charset);
            this.parseHeader();
            if (this.midReader != null) {
                this.midReader.close();
            }
            return this.ds;
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void parseHeaderLine(String[] words) throws IOException {
        if (words[0].equalsIgnoreCase("Version")) {
            this.parseVersion(words);
        } else if (words[0].equalsIgnoreCase("Charset")) {
            this.parseCharset(words);
        } else if (words[0].equalsIgnoreCase("Delimiter")) {
            this.parseDelimiter(words);
        } else if (words[0].equalsIgnoreCase("Unique")) {
            this.parseUnique(words);
        } else if (words[0].equalsIgnoreCase("Index")) {
            this.parseIndex(words);
        } else if (words[0].equalsIgnoreCase("CoordSys")) {
            this.parseCoordSys(words);
        } else if (words[0].equalsIgnoreCase("Transform")) {
            this.parseTransform(words);
        } else if (words[0].equalsIgnoreCase("Columns")) {
            this.parseColumns(words);
        } else if (words[0].equalsIgnoreCase("Data")) {
            this.parseData(words);
        } else if (this.ds != null) {
            if (this.state == State.START_POLYGON) {
                this.numpts = Integer.parseInt(words[0]);
                this.polygon = new Way();
                this.ds.addPrimitive((OsmPrimitive)this.polygon);
                this.region.addMember(new RelationMember("outer", (OsmPrimitive)this.polygon));
                this.state = State.READING_POINTS;
            } else if (this.state == State.START_POLYLINE) {
                this.numpts = Integer.parseInt(words[0]);
                this.polyline = new Way();
                this.ds.addPrimitive((OsmPrimitive)this.polyline);
                this.readAttributes((OsmPrimitive)this.polyline);
                this.state = State.READING_POINTS;
            } else if (this.state == State.READING_POINTS && this.numpts > 0) {
                if (this.josmProj != null) {
                    this.node = this.createNode(words[0], words[1]);
                    if (this.polygon != null) {
                        this.polygon.addNode(this.node);
                    } else if (this.polyline != null) {
                        this.polyline.addNode(this.node);
                    }
                }
                if (--this.numpts == 0) {
                    if (this.numpolygons > -1) {
                        if (--this.numpolygons > 0) {
                            this.state = State.START_POLYGON;
                        } else {
                            this.state = State.END_POLYGON;
                            this.polygon = null;
                        }
                    } else if (this.polyline != null) {
                        this.state = State.UNKNOWN;
                        this.polyline = null;
                    }
                }
            } else if (words[0].equalsIgnoreCase("Point")) {
                this.parsePoint(words);
            } else if (words[0].equalsIgnoreCase("Line")) {
                this.parseLine(words);
            } else if (words[0].equalsIgnoreCase("PLine")) {
                this.parsePLine(words);
            } else if (words[0].equalsIgnoreCase("Region")) {
                this.parseRegion(words);
            } else if (words[0].equalsIgnoreCase("Arc")) {
                this.parseArc(words);
            } else if (words[0].equalsIgnoreCase("Text")) {
                this.parseText(words);
            } else if (words[0].equalsIgnoreCase("Rect")) {
                this.parseRect(words);
            } else if (words[0].equalsIgnoreCase("RoundRect")) {
                this.parseRoundRect(words);
            } else if (words[0].equalsIgnoreCase("Ellipse")) {
                this.parseEllipse(words);
            } else if (!(words[0].equalsIgnoreCase("Pen") || words[0].equalsIgnoreCase("Brush") || words[0].equalsIgnoreCase("Center") || words[0].equalsIgnoreCase("Symbol") || words[0].equalsIgnoreCase("Font") || words[0].isEmpty())) {
                System.err.println("Line " + this.lineNum + ". Unknown clause in data section: " + this.line);
            }
        } else if (this.state == State.READING_COLUMNS && this.numcolumns > 0) {
            this.columns.add(words[0]);
            if (--this.numcolumns == 0) {
                this.state = State.UNKNOWN;
            }
        } else if (!this.line.isEmpty()) {
            System.err.println("Line " + this.lineNum + ". Unknown clause in header: " + this.line);
        }
    }

    protected void readAttributes(OsmPrimitive p) throws IOException {
        String midLine;
        if (this.midReader != null && (midLine = this.midReader.readLine()) != null) {
            String[] fields = OdUtils.stripQuotes(midLine.split(this.delimiter.toString()), this.delimiter.toString());
            if (this.columns.size() != fields.length) {
                System.err.println("Error: Incoherence between MID and MIF files (" + this.columns.size() + " columns vs " + fields.length + " fields)");
            }
            for (int i = 0; i < Math.min(this.columns.size(), fields.length); ++i) {
                String field = fields[i].trim();
                if (field.isEmpty()) continue;
                p.put((String)this.columns.get(i), field);
            }
        }
    }

    protected final Node createNode(String x, String y) {
        Node node = new Node(this.josmProj.eastNorth2latlon(new EastNorth(Double.parseDouble(x), Double.parseDouble(y))));
        this.ds.addPrimitive((OsmPrimitive)node);
        return node;
    }

    public static boolean equals(Double a, Double b) {
        if (a == b) {
            return true;
        }
        return Math.abs(a - b) < 1.0E-7;
    }

    private static enum State {
        UNKNOWN,
        READING_COLUMNS,
        START_POLYGON,
        READING_POINTS,
        END_POLYGON,
        START_POLYLINE,
        END_POLYLINE;

    }
}

