/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.SSCellRange;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSSFSheet
implements Sheet {
    private static final POILogger log = POILogFactory.getLogger(HSSFSheet.class);
    private static final int DEBUG = POILogger.DEBUG;
    private final InternalSheet _sheet;
    private final TreeMap<Integer, HSSFRow> _rows;
    protected final HSSFWorkbook _workbook;
    private int _firstrow;
    private int _lastrow;

    protected HSSFSheet(HSSFWorkbook hSSFWorkbook, InternalSheet internalSheet) {
        this._sheet = internalSheet;
        this._rows = new TreeMap();
        this._workbook = hSSFWorkbook;
        this.setPropertiesFromSheet(internalSheet);
    }

    private void setPropertiesFromSheet(InternalSheet internalSheet) {
        boolean bl;
        RowRecord rowRecord = internalSheet.getNextRow();
        boolean bl2 = bl = rowRecord != null;
        while (rowRecord != null) {
            this.createRowFromRecord(rowRecord);
            rowRecord = internalSheet.getNextRow();
        }
        CellValueRecordInterface[] cellValueRecordInterfaceArray = internalSheet.getValueRecords();
        long l = System.currentTimeMillis();
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"Time at start of cell creating in HSSF sheet = ", l);
        }
        HSSFRow hSSFRow = null;
        for (int i = 0; i < cellValueRecordInterfaceArray.length; ++i) {
            CellValueRecordInterface cellValueRecordInterface = cellValueRecordInterfaceArray[i];
            long l2 = System.currentTimeMillis();
            HSSFRow hSSFRow2 = hSSFRow;
            if (hSSFRow2 == null || hSSFRow2.getRowNum() != cellValueRecordInterface.getRow()) {
                hSSFRow = hSSFRow2 = this.getRow(cellValueRecordInterface.getRow());
                if (hSSFRow2 == null) {
                    if (bl) {
                        throw new RuntimeException("Unexpected missing row when some rows already present");
                    }
                    RowRecord rowRecord2 = new RowRecord(cellValueRecordInterface.getRow());
                    internalSheet.addRow(rowRecord2);
                    hSSFRow2 = this.createRowFromRecord(rowRecord2);
                }
            }
            if (log.check(POILogger.DEBUG)) {
                log.log(DEBUG, "record id = " + Integer.toHexString(((Record)((Object)cellValueRecordInterface)).getSid()));
            }
            hSSFRow2.createCellFromRecord(cellValueRecordInterface);
            if (!log.check(POILogger.DEBUG)) continue;
            log.log(DEBUG, (Object)"record took ", System.currentTimeMillis() - l2);
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"total sheet cell creation took ", System.currentTimeMillis() - l);
        }
    }

    @Override
    public HSSFRow createRow(int n) {
        HSSFRow hSSFRow = new HSSFRow(this._workbook, this, n);
        this.addRow(hSSFRow, true);
        return hSSFRow;
    }

    private HSSFRow createRowFromRecord(RowRecord rowRecord) {
        HSSFRow hSSFRow = new HSSFRow(this._workbook, this, rowRecord);
        this.addRow(hSSFRow, false);
        return hSSFRow;
    }

    private void addRow(HSSFRow hSSFRow, boolean bl) {
        boolean bl2;
        this._rows.put(hSSFRow.getRowNum(), hSSFRow);
        if (bl) {
            this._sheet.addRow(hSSFRow.getRowRecord());
        }
        boolean bl3 = bl2 = this._rows.size() == 1;
        if (hSSFRow.getRowNum() > this.getLastRowNum() || bl2) {
            this._lastrow = hSSFRow.getRowNum();
        }
        if (hSSFRow.getRowNum() < this.getFirstRowNum() || bl2) {
            this._firstrow = hSSFRow.getRowNum();
        }
    }

    @Override
    public HSSFRow getRow(int n) {
        return this._rows.get(n);
    }

    @Override
    public int getFirstRowNum() {
        return this._firstrow;
    }

    @Override
    public int getLastRowNum() {
        return this._lastrow;
    }

    @Override
    public Iterator<Row> rowIterator() {
        Iterator<Row> iterator = this._rows.values().iterator();
        return iterator;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    InternalSheet getSheet() {
        return this._sheet;
    }

    private CellRange<HSSFCell> getCellRange(CellRangeAddress cellRangeAddress) {
        int n = cellRangeAddress.getFirstRow();
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getLastColumn();
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        ArrayList<HSSFCell> arrayList = new ArrayList<HSSFCell>(n5 * n6);
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                HSSFCell hSSFCell;
                HSSFRow hSSFRow = this.getRow(i);
                if (hSSFRow == null) {
                    hSSFRow = this.createRow(i);
                }
                if ((hSSFCell = hSSFRow.getCell(j)) == null) {
                    hSSFCell = hSSFRow.createCell(j);
                }
                arrayList.add(hSSFCell);
            }
        }
        return SSCellRange.create(n, n2, n5, n6, arrayList, HSSFCell.class);
    }

    public CellRange<HSSFCell> removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        CellValueRecordInterface cellValueRecordInterface = ((HSSFCell)cell).getCellValueRecord();
        if (!(cellValueRecordInterface instanceof FormulaRecordAggregate)) {
            String string = new CellReference(cell).formatAsString();
            throw new IllegalArgumentException("Cell " + string + " is not part of an array formula.");
        }
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)cellValueRecordInterface;
        CellRangeAddress cellRangeAddress = formulaRecordAggregate.removeArrayFormula(cell.getRowIndex(), cell.getColumnIndex());
        CellRange<HSSFCell> cellRange = this.getCellRange(cellRangeAddress);
        for (HSSFCell hSSFCell : cellRange) {
            hSSFCell.setCellType(3);
        }
        return cellRange;
    }
}

