/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.tabular;

import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionChooser;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionPatterns;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.tools.I18n;

public abstract class SpreadSheetReader
extends AbstractReader
implements OdConstants {
    private static final NumberFormat formatFrance = NumberFormat.getInstance(Locale.FRANCE);
    private static final NumberFormat formatUK = NumberFormat.getInstance(Locale.UK);
    protected final SpreadSheetHandler handler;

    public SpreadSheetReader(SpreadSheetHandler handler) {
        this.handler = handler;
    }

    protected static double parseDouble(String value) throws ParseException {
        if (value.contains(",")) {
            return formatFrance.parse(value.replace(" ", "")).doubleValue();
        }
        return formatUK.parse(value.replace(" ", "")).doubleValue();
    }

    protected abstract void initResources(InputStream var1, ProgressMonitor var2) throws IOException;

    protected abstract String[] readLine(ProgressMonitor var1) throws IOException;

    protected final int getSheetNumber() {
        return this.handler != null && this.handler.getSheetNumber() > -1 ? this.handler.getSheetNumber() : 0;
    }

    protected final int getLineNumber() {
        return this.handler != null ? this.handler.getLineNumber() : -1;
    }

    public DataSet doParse(String[] header, ProgressMonitor progressMonitor) throws IOException {
        String[] fields;
        boolean handlerOK;
        System.out.println("Header: " + Arrays.toString(header));
        HashMap<ProjectionPatterns, CoordinateColumns> projColumns = new HashMap<ProjectionPatterns, CoordinateColumns>();
        for (int i = 0; i < header.length; ++i) {
            for (ProjectionPatterns pp : PROJECTIONS) {
                CoordinateColumns col = (CoordinateColumns)projColumns.get(pp);
                if (pp.getXPattern().matcher(header[i]).matches()) {
                    if (col == null) {
                        col = new CoordinateColumns();
                        projColumns.put(pp, col);
                    }
                    col.xCol = i;
                    continue;
                }
                if (!pp.getYPattern().matcher(header[i]).matches()) continue;
                if (col == null) {
                    col = new CoordinateColumns();
                    projColumns.put(pp, col);
                }
                col.yCol = i;
            }
        }
        Projection proj = null;
        CoordinateColumns columns = null;
        ArrayList<Integer> allProjIndexes = new ArrayList<Integer>();
        for (ProjectionPatterns pp : projColumns.keySet()) {
            CoordinateColumns col = (CoordinateColumns)projColumns.get(pp);
            if (!col.isOk()) continue;
            if (proj == null) {
                proj = pp.getProjection(header[col.xCol], header[col.yCol]);
                columns = col;
            }
            allProjIndexes.add(col.xCol);
            allProjIndexes.add(col.yCol);
        }
        boolean bl = handlerOK = this.handler != null && this.handler.handlesProjection();
        if (proj == null) {
            if (columns != null) {
                if (!handlerOK) {
                    ProjectionChooser dialog = (ProjectionChooser)new ProjectionChooser(progressMonitor.getWindowParent()).showDialog();
                    if (dialog.getValue() != 1) {
                        return null;
                    }
                    proj = dialog.getProjection();
                }
            } else {
                throw new IllegalArgumentException(I18n.tr((String)"No valid coordinates have been found.", (Object[])new Object[0]));
            }
        }
        System.out.println("Loading data using projection " + proj + " (" + header[columns.xCol] + ", " + header[columns.yCol] + ")");
        DataSet ds = new DataSet();
        int lineNumber = 1;
        while ((fields = this.readLine(progressMonitor)) != null) {
            ++lineNumber;
            EastNorth en = new EastNorth(Double.NaN, Double.NaN);
            if (this.handler != null) {
                this.handler.setXCol(-1);
                this.handler.setYCol(-1);
            }
            Node n = new Node();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    if (i >= header.length) {
                        throw new IllegalArgumentException(I18n.tr((String)"Invalid file. Bad length on line {0}. Expected {1} columns, got {2}.", (Object[])new Object[]{lineNumber, header.length, i + 1}));
                    }
                    if (i == columns.xCol) {
                        en.setLocation(SpreadSheetReader.parseDouble(fields[i]), en.north());
                        if (this.handler == null) continue;
                        this.handler.setXCol(i);
                        continue;
                    }
                    if (i == columns.yCol) {
                        en.setLocation(en.east(), SpreadSheetReader.parseDouble(fields[i]));
                        if (this.handler == null) continue;
                        this.handler.setYCol(i);
                        continue;
                    }
                    if (allProjIndexes.contains(i) || fields[i].isEmpty()) continue;
                    n.put(header[i], fields[i]);
                    continue;
                }
                catch (ParseException e) {
                    System.err.println("Warning: Parsing error on line " + lineNumber + ": " + e.getMessage());
                }
            }
            if (en.isValid()) {
                n.setCoor(proj != null && !handlerOK ? proj.eastNorth2latlon(en) : this.handler.getCoor(en, fields));
            } else {
                System.err.println("Warning: Skipping line " + lineNumber + " because no valid coordinates have been found.");
            }
            if (n.getCoor() == null) continue;
            ds.addPrimitive((OsmPrimitive)n);
        }
        return ds;
    }

    public final DataSet parse(InputStream in, ProgressMonitor progressMonitor) throws IOException {
        this.initResources(in, progressMonitor);
        String[] header = null;
        int length = 0;
        int n = 0;
        while (header == null || length == 0) {
            header = this.readLine(progressMonitor);
            length = 0;
            if (header == null && ++n > this.getLineNumber()) {
                return null;
            }
            if (header == null || this.getLineNumber() != -1 && this.getLineNumber() != n) continue;
            for (String field : header) {
                length += field.length();
            }
        }
        return this.doParse(header, progressMonitor);
    }

    private class CoordinateColumns {
        public int xCol = -1;
        public int yCol = -1;

        private CoordinateColumns() {
        }

        public final boolean isOk() {
            return this.xCol > -1 && this.yCol > -1;
        }
    }
}

