/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.vectorize;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.awt.image.RenderedImage;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.jaitools.CollectionFactory;
import org.jaitools.jts.Utils;
import org.jaitools.media.jai.AttributeOpImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorizeOpImage
extends AttributeOpImage {
    private static final int TL = 0;
    private static final int TR = 1;
    private static final int BL = 2;
    private static final int BR = 3;
    private static final GeometryFactory PACKED_FACTORY = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory());
    private static final SortedMap<Integer, Integer> NBR_CONFIG_LOOKUP = new TreeMap<Integer, Integer>();
    private static final double EPSILON = 1.0E-8;
    private static final int INSIDE_FLAG_VALUE = 1;
    private final int band;
    private SortedSet<Double> outsideValues;
    private final boolean insideEdges;
    private Double inside = null;
    private Map<Integer, LineSegment> vertLines;
    private LineSegment horizLine;
    private List<LineString> lines;
    private static final GeometryFactory GEOMETRY_FACTORY;
    SoftReference<List<Geometry>> cachedVectors;
    private final boolean removeCollinear;
    private final double filterThreshold;
    private final int filterMethod;
    private Random rr;

    public VectorizeOpImage(RenderedImage source, ROI roi, int band, List<Double> outsideValues, boolean insideEdges, boolean removeCollinear, double filterThreshold, int filterMethod) {
        super(source, roi);
        this.band = band;
        this.outsideValues = CollectionFactory.sortedSet();
        if (outsideValues == null || outsideValues.isEmpty()) {
            this.outsideValues.add(Double.NaN);
        } else {
            this.outsideValues.addAll(outsideValues);
        }
        this.insideEdges = insideEdges;
        this.removeCollinear = removeCollinear;
        this.filterThreshold = filterThreshold;
        this.filterMethod = filterMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Geometry> getAttribute(String name) {
        if (this.cachedVectors == null || this.cachedVectors.get() == null) {
            VectorizeOpImage vectorizeOpImage = this;
            synchronized (vectorizeOpImage) {
                this.doVectorize();
            }
        }
        return this.cachedVectors.get();
    }

    protected String[] getAttributeNames() {
        return new String[]{"vectors"};
    }

    private void doVectorize() {
        this.lines = CollectionFactory.list();
        this.vertLines = CollectionFactory.map();
        this.vectorizeBoundaries();
        List<Geometry> polys = this.assemblePolygons();
        if (this.filterThreshold > 0.0) {
            this.filterSmallPolygons(polys);
        }
        this.cachedVectors = new SoftReference<List<Geometry>>(polys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Geometry> assemblePolygons() {
        List<Geometry> polygons = CollectionFactory.list();
        RandomIter imgIter = RandomIterFactory.create(this.getSourceImage(0), null);
        Polygonizer polygonizer = new Polygonizer();
        try {
            polygonizer.add(this.lines);
            Collection rawPolys = polygonizer.getPolygons();
            Iterator it = rawPolys.iterator();
            while (it.hasNext()) {
                Polygon poly = (Polygon)it.next();
                it.remove();
                if (this.removeCollinear) {
                    poly = Utils.removeCollinearVertices(poly);
                }
                Coordinate[] coords = poly.getExteriorRing().getCoordinates();
                Coordinate minCoord = CoordinateArrays.minCoordinate((Coordinate[])coords);
                Coordinate insideCoord = new Coordinate(minCoord.x + 0.5, minCoord.y + 0.5);
                Point insidePt = GEOMETRY_FACTORY.createPoint(insideCoord);
                if (!poly.contains((Geometry)insidePt)) {
                    throw new RuntimeException("Can't locate interior point for polygon");
                }
                double val = imgIter.getSampleDouble((int)insideCoord.x, (int)insideCoord.y, this.band);
                if (this.roi != null && !this.roi.contains(insideCoord.x, insideCoord.y) || this.isOutside(val)) continue;
                poly = (Polygon)PACKED_FACTORY.createGeometry((Geometry)poly);
                if (this.insideEdges) {
                    poly.setUserData((Object)val);
                } else {
                    poly.setUserData((Object)this.inside);
                }
                polygons.add((Geometry)poly);
            }
            List<Geometry> list = polygons;
            return list;
        }
        finally {
            imgIter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vectorizeBoundaries() {
        double[] sample = new double[4];
        boolean[] flag = new boolean[4];
        RandomIter imageIter = RandomIterFactory.create(this.getSourceImage(0), null);
        if (!this.insideEdges) {
            this.setInsideValue();
        }
        Double OUT = this.outsideValues.first();
        try {
            for (int y = this.srcBounds.y - 1; y < this.srcBounds.y + this.srcBounds.height; ++y) {
                sample[1] = sample[3] = OUT.doubleValue();
                flag[3] = false;
                flag[1] = false;
                boolean yFlag = this.srcBounds.contains(this.srcBounds.x, y);
                boolean yNextFlag = this.srcBounds.contains(this.srcBounds.x, y + 1);
                for (int x = this.srcBounds.x - 1; x < this.srcBounds.x + this.srcBounds.width; ++x) {
                    sample[0] = sample[1];
                    flag[0] = flag[1];
                    sample[2] = sample[3];
                    flag[2] = flag[3];
                    flag[1] = yFlag && this.srcBounds.contains(x + 1, y) && (this.roi == null || this.roi.contains(x + 1, y));
                    flag[3] = yNextFlag && this.srcBounds.contains(x + 1, y + 1) && (this.roi == null || this.roi.contains(x + 1, y + 1));
                    double d = sample[1] = flag[1] ? imageIter.getSampleDouble(x + 1, y, this.band) : OUT.doubleValue();
                    if (this.isOutside(sample[1])) {
                        sample[1] = OUT;
                    } else if (!this.insideEdges) {
                        sample[1] = this.inside;
                    }
                    double d2 = sample[3] = flag[3] ? imageIter.getSampleDouble(x + 1, y + 1, this.band) : OUT.doubleValue();
                    if (this.isOutside(sample[3])) {
                        sample[3] = OUT;
                    } else if (!this.insideEdges) {
                        sample[3] = this.inside;
                    }
                    this.updateCoordList(x, y, sample);
                }
            }
        }
        finally {
            imageIter.done();
        }
    }

    private void setInsideValue() {
        Double maxFinite = null;
        for (Double d : this.outsideValues) {
            if (d.isInfinite() || d.isNaN()) continue;
            maxFinite = d;
        }
        this.inside = maxFinite != null ? Double.valueOf(maxFinite + 1.0) : Double.valueOf(1.0);
    }

    private void updateCoordList(int xpixel, int ypixel, double[] sample) {
        int xvec = xpixel + 1;
        int yvec = ypixel + 1;
        int configIndex = VectorizeOpImage.nbrConfig(sample);
        switch (configIndex) {
            case 0: {
                break;
            }
            case 1: {
                this.horizLine = new LineSegment();
                this.horizLine.p0.x = xvec;
                LineSegment seg = new LineSegment();
                seg.p0.y = yvec;
                this.vertLines.put(xvec, seg);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.horizLine.p1.x = xvec;
                this.addHorizLine(yvec);
                this.horizLine = null;
                LineSegment seg = new LineSegment();
                seg.p0.y = yvec;
                this.vertLines.put(xvec, seg);
                break;
            }
            case 4: {
                this.horizLine.p1.x = xvec;
                this.addHorizLine(yvec);
                this.horizLine = null;
                LineSegment seg = this.vertLines.get(xvec);
                seg.p1.y = yvec;
                this.addVertLine(xvec);
                this.vertLines.remove(xvec);
                break;
            }
            case 5: {
                this.horizLine = new LineSegment();
                this.horizLine.p0.x = xvec;
                LineSegment seg = this.vertLines.get(xvec);
                seg.p1.y = yvec;
                this.addVertLine(xvec);
                this.vertLines.remove(xvec);
                break;
            }
            case 6: {
                this.horizLine.p1.x = xvec;
                this.addHorizLine(yvec);
                this.horizLine.p0.x = xvec;
                LineSegment seg = this.vertLines.get(xvec);
                seg.p1.y = yvec;
                this.addVertLine(xvec);
                this.vertLines.remove(xvec);
                break;
            }
            case 7: {
                this.horizLine.p1.x = xvec;
                this.addHorizLine(yvec);
                this.horizLine.p0.x = xvec;
                LineSegment seg = new LineSegment();
                seg.p0.y = yvec;
                this.vertLines.put(xvec, seg);
                break;
            }
            case 8: {
                this.horizLine.p1.x = xvec;
                this.addHorizLine(yvec);
                this.horizLine = null;
                LineSegment seg = this.vertLines.get(xvec);
                seg.p1.y = yvec;
                this.addVertLine(xvec);
                seg = new LineSegment();
                seg.p0.y = yvec;
                this.vertLines.put(xvec, seg);
                break;
            }
            case 9: {
                this.horizLine = new LineSegment();
                this.horizLine.p0.x = xvec;
                LineSegment seg = this.vertLines.get(xvec);
                seg.p1.y = yvec;
                this.addVertLine(xvec);
                seg = new LineSegment();
                seg.p0.y = yvec;
                this.vertLines.put(xvec, seg);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.horizLine.p1.x = xvec;
                this.addHorizLine(yvec);
                this.horizLine.p0.x = xvec;
                LineSegment seg = this.vertLines.get(xvec);
                seg.p1.y = yvec;
                this.addVertLine(xvec);
                seg = new LineSegment();
                seg.p0.y = yvec;
                this.vertLines.put(xvec, seg);
                break;
            }
        }
    }

    private static int nbrConfig(double[] sample) {
        int flag = 0;
        flag |= VectorizeOpImage.isDifferent(sample[1], sample[0]) << 5;
        flag |= VectorizeOpImage.isDifferent(sample[2], sample[0]) << 4;
        flag |= VectorizeOpImage.isDifferent(sample[2], sample[1]) << 3;
        flag |= VectorizeOpImage.isDifferent(sample[3], sample[0]) << 2;
        flag |= VectorizeOpImage.isDifferent(sample[3], sample[1]) << 1;
        return (Integer)NBR_CONFIG_LOOKUP.get(flag |= VectorizeOpImage.isDifferent(sample[3], sample[2]));
    }

    private void addHorizLine(int y) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.horizLine.p0.x, (double)y), new Coordinate(this.horizLine.p1.x, (double)y)};
        this.lines.add(GEOMETRY_FACTORY.createLineString(coords));
    }

    private void addVertLine(int x) {
        Coordinate[] coords = new Coordinate[]{new Coordinate((double)x, this.vertLines.get((Object)Integer.valueOf((int)x)).p0.y), new Coordinate((double)x, this.vertLines.get((Object)Integer.valueOf((int)x)).p1.y)};
        this.lines.add(GEOMETRY_FACTORY.createLineString(coords));
    }

    private boolean isOutside(double value) {
        for (Double d : this.outsideValues) {
            if (VectorizeOpImage.isDifferent(d, value) != 0) continue;
            return true;
        }
        return false;
    }

    private static int isDifferent(double a, double b) {
        if (Double.isNaN(a) ^ Double.isNaN(b)) {
            return 1;
        }
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return 0;
        }
        if (Math.abs(a - b) > 1.0E-8) {
            return 1;
        }
        return 0;
    }

    private void filterSmallPolygons(List<Geometry> polys) {
        boolean foundMergers;
        List toFilter = CollectionFactory.list();
        List holdOver = CollectionFactory.list();
        ListIterator<Geometry> polysIter = polys.listIterator();
        while (polysIter.hasNext()) {
            Geometry poly = polysIter.next();
            if (!(poly.getArea() < this.filterThreshold)) continue;
            polysIter.remove();
            if (this.filterMethod == 2) continue;
            toFilter.add(poly);
        }
        if (toFilter.isEmpty()) {
            return;
        }
        Quadtree spIndex = new Quadtree();
        for (Geometry poly : polys) {
            spIndex.insert(poly.getEnvelopeInternal(), (Object)poly);
        }
        do {
            foundMergers = false;
            ListIterator filterIter = toFilter.listIterator();
            while (filterIter.hasNext()) {
                Geometry smallPoly = (Geometry)filterIter.next();
                filterIter.remove();
                List nbrs = spIndex.query(smallPoly.getEnvelopeInternal());
                Geometry selectedNbr = null;
                if (!nbrs.isEmpty()) {
                    switch (this.filterMethod) {
                        case 0: {
                            selectedNbr = this.getLargestNbr(smallPoly, nbrs);
                            break;
                        }
                        case 1: {
                            selectedNbr = this.getRandomNbr(smallPoly, nbrs);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid filterMethod value");
                        }
                    }
                }
                if (selectedNbr != null) {
                    foundMergers = true;
                    spIndex.remove(selectedNbr.getEnvelopeInternal(), (Object)selectedNbr);
                    this.removePolygon(polys, selectedNbr);
                    Geometry merged = selectedNbr.union(smallPoly);
                    merged.setUserData(selectedNbr.getUserData());
                    spIndex.insert(merged.getEnvelopeInternal(), (Object)merged);
                    polys.add(merged);
                    continue;
                }
                holdOver.add(smallPoly);
            }
            toFilter.addAll(holdOver);
            holdOver.clear();
        } while (foundMergers && !toFilter.isEmpty());
    }

    private Geometry getLargestNbr(Geometry smallPoly, List nbrs) {
        Geometry largestNbr = null;
        ListIterator nbrsIter = nbrs.listIterator();
        double maxArea = 0.0;
        while (nbrsIter.hasNext()) {
            Geometry g = (Geometry)nbrsIter.next();
            if (smallPoly.relate(g, "****1****")) {
                double area = g.getArea();
                if (!(area > maxArea)) continue;
                maxArea = area;
                largestNbr = g;
                continue;
            }
            nbrsIter.remove();
        }
        return largestNbr;
    }

    private Geometry getRandomNbr(Geometry smallPoly, List nbrs) {
        Geometry selected = null;
        ListIterator nbrsIter = nbrs.listIterator();
        while (nbrsIter.hasNext()) {
            Geometry g = (Geometry)nbrsIter.next();
            if (smallPoly.relate(g, "****1****")) continue;
            nbrsIter.remove();
        }
        if (!nbrs.isEmpty()) {
            if (this.rr == null) {
                this.rr = new Random();
            }
            int index = this.rr.nextInt(nbrs.size());
            selected = (Geometry)nbrs.get(index);
        }
        return selected;
    }

    private void removePolygon(List<Geometry> polys, Geometry toRemove) {
        int k = 0;
        for (Geometry p : polys) {
            if (p.equalsExact(toRemove, 1.0E-8)) {
                polys.remove(k);
                return;
            }
            ++k;
        }
        throw new RuntimeException("Failed to remove polygon");
    }

    static {
        NBR_CONFIG_LOOKUP.put(45, 0);
        NBR_CONFIG_LOOKUP.put(7, 1);
        NBR_CONFIG_LOOKUP.put(30, 2);
        NBR_CONFIG_LOOKUP.put(25, 3);
        NBR_CONFIG_LOOKUP.put(52, 4);
        NBR_CONFIG_LOOKUP.put(42, 5);
        NBR_CONFIG_LOOKUP.put(62, 6);
        NBR_CONFIG_LOOKUP.put(31, 7);
        NBR_CONFIG_LOOKUP.put(61, 8);
        NBR_CONFIG_LOOKUP.put(47, 9);
        NBR_CONFIG_LOOKUP.put(55, 10);
        NBR_CONFIG_LOOKUP.put(59, 11);
        NBR_CONFIG_LOOKUP.put(51, 12);
        NBR_CONFIG_LOOKUP.put(63, 13);
        NBR_CONFIG_LOOKUP.put(0, 14);
        GEOMETRY_FACTORY = new GeometryFactory(new PrecisionModel(10.0));
    }
}

