/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Collection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AssociationImpl;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.opengis.feature.Association;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AssociationDescriptor;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractFeatureFactoryImpl
implements FeatureFactory {
    CRSFactory crsFactory;
    GeometryFactory geometryFactory;
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    boolean validating = false;

    public CRSFactory getCRSFactory() {
        return this.crsFactory;
    }

    public void setCRSFactory(CRSFactory crsFactory) {
        this.crsFactory = crsFactory;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    @Override
    public Association createAssociation(Attribute related, AssociationDescriptor descriptor) {
        return new AssociationImpl(related, descriptor);
    }

    @Override
    public Attribute createAttribute(Object value, AttributeDescriptor descriptor, String id) {
        return new AttributeImpl(value, descriptor, id == null ? null : this.ff.gmlObjectId(id));
    }

    @Override
    public GeometryAttribute createGeometryAttribute(Object value, GeometryDescriptor descriptor, String id, CoordinateReferenceSystem crs) {
        return new GeometryAttributeImpl(value, descriptor, id == null ? null : this.ff.gmlObjectId(id));
    }

    public ComplexAttribute createComplexAttribute(Collection value, AttributeDescriptor descriptor, String id) {
        return new ComplexAttributeImpl((Collection<Property>)value, descriptor, id == null ? null : this.ff.gmlObjectId(id));
    }

    public ComplexAttribute createComplexAttribute(Collection value, ComplexType type, String id) {
        return new ComplexAttributeImpl((Collection<Property>)value, type, id == null ? null : this.ff.gmlObjectId(id));
    }

    public Feature createFeature(Collection value, AttributeDescriptor descriptor, String id) {
        return new FeatureImpl((Collection<Property>)value, descriptor, this.ff.featureId(id));
    }

    public Feature createFeature(Collection value, FeatureType type, String id) {
        return new FeatureImpl((Collection<Property>)value, type, this.ff.featureId(id));
    }

    @Override
    public SimpleFeature createSimpleFeature(Object[] array, SimpleFeatureType type, String id) {
        if (type.isAbstract()) {
            throw new IllegalArgumentException("Cannot create an feature of an abstract FeatureType " + type.getTypeName());
        }
        return new SimpleFeatureImpl(array, type, this.ff.featureId(id), this.validating);
    }

    @Override
    public SimpleFeature createSimpleFeautre(Object[] array, AttributeDescriptor descriptor, String id) {
        return this.createSimpleFeature(array, (SimpleFeatureType)((Object)descriptor), id);
    }
}

