/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;

public class DiffTransactionState
implements Transaction.State {
    protected Diff diff;
    protected Transaction transaction;
    protected ContentState state;

    public DiffTransactionState(ContentState state) {
        this.state = state;
        this.diff = new Diff();
    }

    public Diff getDiff() {
        return this.diff;
    }

    public synchronized void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void commit() throws IOException {
        if (this.diff.isEmpty()) {
            return;
        }
        ContentEntry entry = this.state.getEntry();
        Name name = entry.getName();
        ContentDataStore dataStore = entry.getDataStore();
        ContentFeatureSource source = (ContentFeatureSource)dataStore.getFeatureSource(name);
        if (!(source instanceof ContentFeatureStore)) throw new UnsupportedOperationException("not writable");
        ContentFeatureStore store = (ContentFeatureStore)dataStore.getFeatureSource(name);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = store.getWriter((Filter)Filter.INCLUDE);
        Exception cause = null;
        try {
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                String fid = feature.getID();
                if (!this.diff.getModified().containsKey(fid)) continue;
                SimpleFeature update = (SimpleFeature)this.diff.getModified().get(fid);
                if (update == TransactionStateDiff.NULL) {
                    writer.remove();
                    this.state.fireFeatureRemoved((FeatureSource<?, ?>)store, (Feature)feature);
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes());
                    writer.write();
                    ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)feature.getBounds());
                    this.state.fireFeatureUpdated((FeatureSource<?, ?>)store, (Feature)update, bounds);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, (Throwable)e);
                }
            }
            Diff diff = this.diff;
            synchronized (diff) {
                Iterator i$ = this.diff.getAddedOrder().iterator();
                while (i$.hasNext()) {
                    String fid = (String)i$.next();
                    SimpleFeature addedFeature = (SimpleFeature)this.diff.getAdded().get(fid);
                    SimpleFeature nextFeature = (SimpleFeature)writer.next();
                    if (nextFeature == null) {
                        throw new DataSourceException("Could not add " + fid);
                    }
                    try {
                        nextFeature.setAttributes(addedFeature.getAttributes());
                        nextFeature.getUserData().put(Hints.USE_PROVIDED_FID, true);
                        if (addedFeature.getUserData().containsKey(Hints.PROVIDED_FID)) {
                            String providedFid = (String)addedFeature.getUserData().get(Hints.PROVIDED_FID);
                            nextFeature.getUserData().put(Hints.PROVIDED_FID, providedFid);
                        } else {
                            nextFeature.getUserData().put(Hints.PROVIDED_FID, addedFeature.getID());
                        }
                        writer.write();
                        this.state.fireFeatureAdded((FeatureSource<?, ?>)store, (Feature)nextFeature);
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Could update " + fid, (Throwable)e);
                    }
                }
                return;
            }
        }
        catch (IOException e) {
            cause = e;
            throw e;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            try {
                writer.close();
                this.state.fireBatchFeatureEvent(true);
                this.diff.clear();
            }
            catch (IOException e) {
                if (cause == null) throw e;
                e.initCause(cause);
                throw e;
            }
            catch (RuntimeException e) {
                if (cause == null) throw e;
                e.initCause(cause);
                throw e;
            }
        }
    }

    public synchronized void rollback() throws IOException {
        this.diff.clear();
        this.state.fireBatchFeatureEvent(false);
    }

    public synchronized void addAuthorization(String AuthID) throws IOException {
    }
}

