/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geotools;

import com.sun.media.jai.imageioimpl.ImageReadWriteSpi;
import java.io.IOException;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class GeoToolsPlugin
extends Plugin {
    public GeoToolsPlugin(PluginInformation info) {
        super(info);
        this.initJAI();
        this.checkEPSG();
    }

    private void initJAI() {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        if (registry == null) {
            System.err.println("geotools: error in JAI initialization. Cannot access default operation registry");
        } else {
            new ImageReadWriteSpi().updateRegistry(registry);
            InputStream in = GeoToolsPlugin.class.getResourceAsStream("/META-INF/registryFile.jai");
            if (in == null) {
                System.err.println("geotools: error in JAI initialization. Cannot access META-INF/registryFile.jai");
            } else {
                try {
                    registry.updateFromStream(in);
                }
                catch (IOException e) {
                    System.err.println("geotools: error in JAI initialization. Cannot update default operation registry");
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.err.println("geotools: error in JAI initialization. Cannot close input stream");
                }
            }
        }
    }

    private void checkEPSG() {
        try {
            CRS.decode("EPSG:4326");
        }
        catch (NoSuchAuthorityCodeException e) {
            System.err.println("geotools: error in EPSG database initialization. NoSuchAuthorityCodeException: " + e.getMessage());
        }
        catch (FactoryException e) {
            System.err.println("geotools: error in EPSG database initialization. FactoryException: " + e.getMessage());
        }
    }
}

