/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.util.Date;

public class ShapefileUtilities {
    private ShapefileUtilities() {
    }

    public static Object forAttribute(Object o, Class colType) {
        Object object;
        if (colType == Integer.class) {
            object = o;
        } else if (colType == Short.class || colType == Byte.class) {
            object = new Integer(((Number)o).intValue());
        } else if (colType == Double.class) {
            object = o;
        } else if (colType == Float.class) {
            object = new Double(((Number)o).doubleValue());
        } else if (Number.class.isAssignableFrom(colType)) {
            object = o;
        } else if (colType == String.class) {
            object = o == null ? o : o.toString();
        } else if (colType == Boolean.class) {
            object = o;
        } else if (Date.class.isAssignableFrom(colType)) {
            object = o;
        } else {
            if (colType != null) {
                throw new RuntimeException("Cannot convert " + colType.getName());
            }
            throw new RuntimeException("Null Class for conversion");
        }
        return object;
    }
}

