/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.directory.DirectoryDataStore;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;

public class ShapefileDataStoreFactory
extends AbstractDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "url to a .shp file", true, null, (Map)new KVP(new Object[]{"ext", "shp"}));
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false, null, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param MEMORY_MAPPED = new DataAccessFactory.Param("memory mapped buffer", Boolean.class, "enable/disable the use of memory-mapped io", false, (Object)false, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param CACHE_MEMORY_MAPS = new DataAccessFactory.Param("cache and reuse memory maps", Boolean.class, "only memory map a file one, then cache and reuse the map", false, (Object)true, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param FILE_TYPE = new DataAccessFactory.Param("filetype", String.class, "Discriminator for directory stores", false, (Object)"shapefile", (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param CREATE_SPATIAL_INDEX = new DataAccessFactory.Param("create spatial index", Boolean.class, "enable/disable the automatic creation of spatial index", false, (Object)true, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param DBFCHARSET = new DataAccessFactory.Param("charset", Charset.class, "character used to decode strings from the DBF file", false, Charset.forName("ISO-8859-1"), (Map)new KVP(new Object[]{"level", "advanced"})){

        public Object parse(String text) throws IOException {
            return Charset.forName(text);
        }

        public String text(Object value) {
            return ((Charset)value).name();
        }
    };
    public static final DataAccessFactory.Param DBFTIMEZONE = new DataAccessFactory.Param("timezone", TimeZone.class, "time zone used to read dates from the DBF file", false, TimeZone.getDefault(), (Map)new KVP(new Object[]{"level", "advanced"})){

        public Object parse(String text) throws IOException {
            return TimeZone.getTimeZone(text);
        }

        public String text(Object value) {
            return ((TimeZone)value).getID();
        }
    };
    public static final DataAccessFactory.Param FSTYPE = new DataAccessFactory.Param("fstype", String.class, "Enable 'shape' or 'index'.", false, (Object)"shape", (Map)new KVP(new Object[]{"level", "advanced", "options", Arrays.asList("shape", "index")}));

    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        if (params.containsKey(ShapefileDataStoreFactory.URLP.key)) {
            try {
                URL url = (URL)URLP.lookUp(params);
                if (!this.canProcess(url)) {
                    boolean testFileTest;
                    Object fileType = FILE_TYPE.lookUp(params);
                    File dir = DataUtilities.urlToFile((URL)url);
                    boolean bl = testFileTest = dir.isDirectory() && (fileType == null || "shapefile".equals(fileType));
                    if (!testFileTest) {
                        return false;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public DataStore createDataStore(Map params) throws IOException {
        return this.createNewDataStore(params);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        File dir;
        URL url = (URL)URLP.lookUp(params);
        Boolean isMemoryMapped = (Boolean)MEMORY_MAPPED.lookUp(params);
        Boolean cacheMemoryMaps = (Boolean)CACHE_MEMORY_MAPS.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        Charset dbfCharset = (Charset)DBFCHARSET.lookUp(params);
        TimeZone dbfTimeZone = (TimeZone)DBFTIMEZONE.lookUp(params);
        Boolean isCreateSpatialIndex = (Boolean)CREATE_SPATIAL_INDEX.lookUp(params);
        if (isCreateSpatialIndex == null) {
            isCreateSpatialIndex = Boolean.TRUE;
        }
        if (dbfCharset == null) {
            dbfCharset = Charset.forName("ISO-8859-1");
        }
        if (dbfTimeZone == null) {
            dbfTimeZone = TimeZone.getDefault();
        }
        if (isMemoryMapped == null) {
            isMemoryMapped = Boolean.FALSE;
        }
        if (cacheMemoryMaps == null) {
            cacheMemoryMaps = Boolean.FALSE;
        }
        if ((dir = DataUtilities.urlToFile((URL)url)) != null && dir.isDirectory()) {
            return new DirectoryDataStore(DataUtilities.urlToFile((URL)url), (FileStoreFactory)new ShpFileStoreFactory(this, params));
        }
        ShpFiles shpFiles = new ShpFiles(url);
        boolean isLocal = shpFiles.isLocal();
        boolean useMemoryMappedBuffer = isLocal && isMemoryMapped != false;
        boolean createIndex = isCreateSpatialIndex != false && isLocal;
        try {
            ShapefileDataStore store = createIndex ? new IndexedShapefileDataStore(url, namespace, useMemoryMappedBuffer, cacheMemoryMaps, true, IndexType.QIX, dbfCharset) : new ShapefileDataStore(url, namespace, useMemoryMappedBuffer, cacheMemoryMaps, dbfCharset);
            store.setDbftimeZone(dbfTimeZone);
            return store;
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Url for shapefile malformed: " + url, (Throwable)mue);
        }
    }

    public String getDisplayName() {
        return "Shapefile";
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public boolean isAvailable() {
        try {
            ShapefileDataStore.class.getName();
            IndexedShapefileDataStore.class.getName();
            Geometry.class.getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP, NAMESPACEP, CREATE_SPATIAL_INDEX, DBFCHARSET, DBFTIMEZONE, MEMORY_MAPPED, CACHE_MEMORY_MAPS, FILE_TYPE, FSTYPE};
    }

    public String[] getFileExtensions() {
        return new String[]{".shp"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toUpperCase().endsWith("SHP");
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        File file = DataUtilities.urlToFile((URL)url);
        if (file != null && file.isDirectory()) {
            return null;
        }
        if (isLocal && !file.exists()) {
            return (FileDataStore)this.createNewDataStore(params);
        }
        return (FileDataStore)this.createDataStore(params);
    }

    public DataStore createDataStore(URL url, boolean memorymapped) throws IOException {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, new Boolean(memorymapped));
        return this.createDataStore(params);
    }

    public String getTypeName(URL url) throws IOException {
        FileDataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        ds.dispose();
        return names == null || names.length == 0 ? null : names[0];
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public static class ShpFileStoreFactory
    implements FileStoreFactory {
        ShapefileDataStoreFactory shpFactory;
        Map originalParams;

        public ShpFileStoreFactory(ShapefileDataStoreFactory factory, Map originalParams) {
            this.shpFactory = factory;
            this.originalParams = originalParams;
        }

        public DataStore getDataStore(File file) throws IOException {
            URL url = DataUtilities.fileToURL((File)file);
            if (this.shpFactory.canProcess(url)) {
                HashMap<String, URL> params = new HashMap<String, URL>(this.originalParams);
                params.put(ShapefileDataStoreFactory.URLP.key, url);
                return this.shpFactory.createDataStore(params);
            }
            return null;
        }
    }
}

