/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.contour;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jaitools.jts.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Segments {
    static final int MAX_SIZE = 16348;
    boolean simplify;
    double[] ordinates;
    int idx = 0;
    List<LineString> result = new ArrayList<LineString>();

    public Segments(boolean simplify) {
        this.simplify = simplify;
    }

    public void add(double x1, double y1, double x2, double y2) {
        if (this.ordinates == null) {
            this.ordinates = new double[512];
        } else if (this.idx + 4 > this.ordinates.length) {
            double[] temp = new double[this.ordinates.length * 2];
            System.arraycopy(this.ordinates, 0, temp, 0, this.ordinates.length);
            this.ordinates = temp;
        }
        this.ordinates[this.idx++] = x1;
        this.ordinates[this.idx++] = y1;
        this.ordinates[this.idx++] = x2;
        this.ordinates[this.idx++] = y2;
        if (this.idx >= 16348) {
            this.merge();
        }
    }

    public List<LineString> getMergedSegments() {
        if (this.idx > 0) {
            this.merge();
            this.ordinates = null;
        }
        return this.result;
    }

    void merge() {
        LineMerger merger = new LineMerger();
        int i = 0;
        while (i < this.idx) {
            Coordinate p2;
            Coordinate p1;
            if ((p1 = new Coordinate(this.ordinates[i++], this.ordinates[i++])).equals2D(p2 = new Coordinate(this.ordinates[i++], this.ordinates[i++]))) continue;
            merger.add((Geometry)Utils.getGeometryFactory().createLineString(new Coordinate[]{p1, p2}));
        }
        this.idx = 0;
        for (LineString ls : this.result) {
            merger.add((Geometry)ls);
        }
        Collection mergedLines = merger.getMergedLineStrings();
        this.result.clear();
        if (this.simplify) {
            for (LineString merged : mergedLines) {
                if (this.simplify) {
                    merged = Utils.removeCollinearVertices(merged);
                }
                this.result.add(merged);
            }
        } else {
            this.result.addAll(mergedLines);
        }
    }
}

