/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.Map;
import java.util.logging.Logger;
import javax.swing.tree.TreeModel;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.util.logging.Logging;

public abstract class AbstractMetadata {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.metadata");
    private transient int hashCode;
    private transient Map<String, Object> asMap;

    protected AbstractMetadata() {
    }

    protected AbstractMetadata(Object source) throws ClassCastException, UnmodifiableMetadataException {
        this.getStandard().shallowCopy(source, this, true);
    }

    public abstract MetadataStandard getStandard();

    public Class<?> getInterface() {
        return this.getStandard().getInterface(this.getClass());
    }

    boolean isModifiable() {
        return this.getStandard().isModifiable(this.getClass());
    }

    void invalidate() {
        assert (Thread.holdsLock(this));
        this.hashCode = 0;
    }

    public synchronized Map<String, Object> asMap() {
        if (this.asMap == null) {
            this.asMap = this.getStandard().asMap(this);
        }
        return this.asMap;
    }

    public synchronized TreeModel asTree() {
        return this.getStandard().asTree(this);
    }

    public boolean equals(Object object) {
        int c1;
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        int c0 = this.hashCode;
        if (c0 != 0 && (c1 = ((AbstractMetadata)object).hashCode) != 0 && c0 != c1) {
            return false;
        }
        MetadataStandard standard = this.getStandard();
        return standard.shallowEquals(this, object, false);
    }

    public synchronized int hashCode() {
        int code = this.hashCode;
        if (code == 0) {
            code = this.getStandard().hashCode(this);
            if (!this.isModifiable()) {
                this.hashCode = code;
            }
        }
        return code;
    }

    public synchronized String toString() {
        return this.getStandard().toString(this);
    }
}

