/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.rangelookup;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.List;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import org.jaitools.media.jai.rangelookup.RangeLookupOpImage;
import org.jaitools.media.jai.rangelookup.RangeLookupTable;

public class RangeLookupRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        RenderedImage src = paramBlock.getRenderedSource(0);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        RangeLookupTable table = (RangeLookupTable)paramBlock.getObjectParameter(0);
        List items = table.getItems();
        Class<?> destClazz = items.size() > 0 ? items.get((int)0).value.getClass() : table.getDefaultValue().getClass();
        int dataType = -1;
        if (destClazz.equals(Byte.class)) {
            dataType = 0;
        } else if (destClazz.equals(Short.class)) {
            for (int i = items.size() - 1; i >= 0; --i) {
                if (((Number)items.get((int)i).value).shortValue() >= 0) continue;
                dataType = 2;
                break;
            }
            if (dataType == -1) {
                dataType = 1;
            }
        } else if (destClazz.equals(Integer.class)) {
            dataType = 3;
        } else if (destClazz.equals(Float.class)) {
            dataType = 4;
        } else if (destClazz.equals(Double.class)) {
            dataType = 5;
        } else {
            throw new IllegalArgumentException("Illegal destination class for this rangelookuptable:" + destClazz.toString());
        }
        boolean isDataTypeChanged = src.getSampleModel().getDataType() != dataType;
        if (isDataTypeChanged) {
            layout = layout == null ? new ImageLayout(src) : (ImageLayout)layout.clone();
            SampleModel sampleModel = layout.getSampleModel(src);
            int tileWidth = layout.getTileWidth(src);
            int tileHeight = layout.getTileHeight(src);
            int numBands = src.getSampleModel().getNumBands();
            SampleModel csm = RasterFactory.createComponentSampleModel((SampleModel)sampleModel, (int)dataType, (int)tileWidth, (int)tileHeight, (int)numBands);
            layout.setSampleModel(csm);
            ColorModel colorModel = layout.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)layout.getSampleModel(null), (ColorModel)colorModel)) {
                layout.unsetValid(512);
            }
        }
        return new RangeLookupOpImage(src, renderHints, layout, table);
    }
}

