/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.style.Description;
import org.opengis.util.Cloneable;

public class StyleImpl
implements Style,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.styling");
    private List<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
    private DescriptionImpl description = new DescriptionImpl();
    private String name = "Default Styler";
    private boolean defaultB = false;
    private Symbolizer defaultSymbolizer;

    protected StyleImpl() {
    }

    @Override
    public DescriptionImpl getDescription() {
        return this.description;
    }

    @Override
    @Deprecated
    public String getAbstract() {
        if (this.description == null || this.description.getAbstract() == null) {
            return null;
        }
        return ((Object)this.description.getAbstract()).toString();
    }

    @Override
    public FeatureTypeStyle[] getFeatureTypeStyles() {
        FeatureTypeStyle[] ret = new FeatureTypeStyleImpl[]{new FeatureTypeStyleImpl()};
        if (this.featureTypeStyles != null && this.featureTypeStyles.size() != 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("number of fts set " + this.featureTypeStyles.size());
            }
            ret = this.featureTypeStyles.toArray(new FeatureTypeStyle[0]);
        }
        return ret;
    }

    @Override
    public List<FeatureTypeStyle> featureTypeStyles() {
        return this.featureTypeStyles;
    }

    @Override
    public Symbolizer getDefaultSpecification() {
        return this.defaultSymbolizer;
    }

    @Override
    public void setDefaultSpecification(Symbolizer defaultSymbolizer) {
        this.defaultSymbolizer = defaultSymbolizer;
    }

    @Override
    public void setFeatureTypeStyles(FeatureTypeStyle[] styles) {
        List<FeatureTypeStyle> newStyles = Arrays.asList(styles);
        this.featureTypeStyles.clear();
        this.featureTypeStyles.addAll(newStyles);
        LOGGER.fine("StyleImpl added " + this.featureTypeStyles.size() + " feature types");
    }

    @Override
    public void addFeatureTypeStyle(FeatureTypeStyle type) {
        this.featureTypeStyles.add(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Deprecated
    public String getTitle() {
        if (this.description == null || this.description.getTitle() == null) {
            return null;
        }
        return ((Object)this.description.getTitle()).toString();
    }

    @Override
    public boolean isDefault() {
        return this.defaultB;
    }

    @Override
    @Deprecated
    public void setAbstract(String abstractStr) {
        if (this.description == null) {
            this.description = new DescriptionImpl();
        }
        this.description.setAbstract(abstractStr == null ? null : new SimpleInternationalString(abstractStr));
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.defaultB = isDefault;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Deprecated
    public void setTitle(String title) {
        if (this.description == null) {
            this.description = new DescriptionImpl();
        }
        this.description.setTitle(title == null ? null : new SimpleInternationalString(title));
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        Style clone;
        try {
            clone = (Style)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        FeatureTypeStyle[] ftsArray = new FeatureTypeStyle[this.featureTypeStyles.size()];
        for (int i = 0; i < ftsArray.length; ++i) {
            FeatureTypeStyle fts = this.featureTypeStyles.get(i);
            ftsArray[i] = (FeatureTypeStyle)((Cloneable)((Object)fts)).clone();
        }
        clone.setFeatureTypeStyles(ftsArray);
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.featureTypeStyles != null) {
            result = 1000003 * result + ((Object)this.featureTypeStyles).hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        result = 1000003 * result + (this.defaultB ? 1 : 0);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof StyleImpl) {
            StyleImpl other = (StyleImpl)oth;
            return Utilities.equals(this.name, other.name) && Utilities.equals(this.description, other.description) && Utilities.equals(this.featureTypeStyles, other.featureTypeStyles);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StyleImpl");
        buf.append("[");
        if (this.name != null) {
            buf.append(" name=");
            buf.append(this.name);
        } else {
            buf.append(" UNNAMED");
        }
        if (this.defaultB) {
            buf.append(", DEFAULT");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    public void setDescription(Description description) {
        this.description = DescriptionImpl.cast(description);
    }
}

