/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.geotools.geometry.AbstractDirectPosition;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.GeometrySmoother;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.TransformPathNotFoundException;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.resources.Classes;
import org.geotools.resources.geometry.ShapeUtilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class JTS {
    private static final GeneralDirectPosition[] POSITIONS = new GeneralDirectPosition[4];
    private static final Map<CoordinateReferenceSystem, GeodeticCalculator> CALCULATORS;

    private JTS() {
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(143, name));
        }
    }

    public static Envelope transform(Envelope envelope, MathTransform transform) throws TransformException {
        return JTS.transform(envelope, null, transform, 5);
    }

    public static Envelope transform(Envelope sourceEnvelope, Envelope targetEnvelope, MathTransform transform, int npoints) throws TransformException {
        int t;
        JTS.ensureNonNull("sourceEnvelope", sourceEnvelope);
        JTS.ensureNonNull("transform", transform);
        if (transform.getSourceDimensions() != 2 || transform.getTargetDimensions() != 2) {
            throw new MismatchedDimensionException(Errors.format(15, Classes.getShortClassName(transform)));
        }
        double[] coordinates = new double[4 * ++npoints * 2];
        double xmin = sourceEnvelope.getMinX();
        double xmax = sourceEnvelope.getMaxX();
        double ymin = sourceEnvelope.getMinY();
        double ymax = sourceEnvelope.getMaxY();
        double scaleX = (xmax - xmin) / (double)npoints;
        double scaleY = (ymax - ymin) / (double)npoints;
        int offset = 0;
        for (t = 0; t < npoints; ++t) {
            double dx = scaleX * (double)t;
            double dy = scaleY * (double)t;
            coordinates[offset++] = xmin;
            coordinates[offset++] = ymin + dy;
            coordinates[offset++] = xmin + dx;
            coordinates[offset++] = ymax;
            coordinates[offset++] = xmax;
            coordinates[offset++] = ymax - dy;
            coordinates[offset++] = xmax - dx;
            coordinates[offset++] = ymin;
        }
        assert (offset == coordinates.length);
        JTS.xform(transform, coordinates, coordinates);
        if (targetEnvelope == null) {
            targetEnvelope = new Envelope();
        }
        t = 0;
        while (t < offset) {
            targetEnvelope.expandToInclude(coordinates[t++], coordinates[t++]);
        }
        return targetEnvelope;
    }

    public static Geometry transform(Geometry geom, MathTransform transform) throws MismatchedDimensionException, TransformException {
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        transformer.setMathTransform(transform);
        return transformer.transform(geom);
    }

    public static Coordinate transform(Coordinate source, Coordinate dest, MathTransform transform) throws TransformException {
        JTS.ensureNonNull("source", source);
        JTS.ensureNonNull("transform", transform);
        if (dest == null) {
            dest = new Coordinate();
        }
        double[] array = new double[transform.getTargetDimensions()];
        JTS.copy(source, array);
        transform.transform(array, 0, array, 0, 1);
        switch (transform.getTargetDimensions()) {
            case 3: {
                dest.z = array[2];
            }
            case 2: {
                dest.y = array[1];
            }
            case 1: {
                dest.x = array[0];
            }
        }
        return dest;
    }

    public static Envelope toGeographic(Envelope envelope, CoordinateReferenceSystem crs) throws TransformException {
        MathTransform transform;
        if (CRS.equalsIgnoreMetadata(crs, DefaultGeographicCRS.WGS84)) {
            return envelope;
        }
        try {
            transform = CRS.findMathTransform(crs, DefaultGeographicCRS.WGS84, true);
        }
        catch (FactoryException exception) {
            throw new TransformPathNotFoundException(Errors.format(33, exception));
        }
        return JTS.transform(envelope, transform);
    }

    public static void xform(MathTransform transform, double[] src, double[] dest) throws TransformException {
        JTS.ensureNonNull("transform", transform);
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (targetDim != sourceDim) {
            throw new MismatchedDimensionException();
        }
        TransformException firstError = null;
        boolean startPointTransformed = false;
        for (int i = 0; i < src.length; i += sourceDim) {
            try {
                transform.transform(src, i, dest, i, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(dest, j, dest, i, targetDim);
                }
                continue;
            }
            catch (TransformException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (!startPointTransformed) continue;
                System.arraycopy(dest, i - targetDim, dest, i, targetDim);
            }
        }
        if (!startPointTransformed && firstError != null) {
            throw firstError;
        }
    }

    public static synchronized double orthodromicDistance(Coordinate p1, Coordinate p2, CoordinateReferenceSystem crs) throws TransformException {
        JTS.ensureNonNull("p1", p1);
        JTS.ensureNonNull("p2", p2);
        JTS.ensureNonNull("crs", crs);
        GeodeticCalculator gc = CALCULATORS.get(crs);
        if (gc == null) {
            gc = new GeodeticCalculator(crs);
            CALCULATORS.put(crs, gc);
        }
        assert (crs.equals(gc.getCoordinateReferenceSystem())) : crs;
        GeneralDirectPosition pos = POSITIONS[Math.min(POSITIONS.length - 1, crs.getCoordinateSystem().getDimension())];
        pos.setCoordinateReferenceSystem(crs);
        JTS.copy(p1, pos.ordinates);
        gc.setStartingPosition(pos);
        JTS.copy(p2, pos.ordinates);
        gc.setDestinationPosition(pos);
        return gc.getOrthodromicDistance();
    }

    public static DirectPosition toDirectPosition(final Coordinate point, final CoordinateReferenceSystem crs) {
        return new AbstractDirectPosition(){

            @Override
            public CoordinateReferenceSystem getCoordinateReferenceSystem() {
                return crs;
            }

            @Override
            public int getDimension() {
                return crs.getCoordinateSystem().getDimension();
            }

            @Override
            public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
                switch (dimension) {
                    case 0: {
                        return point.x;
                    }
                    case 1: {
                        return point.y;
                    }
                    case 2: {
                        return point.z;
                    }
                }
                return Double.NaN;
            }

            @Override
            public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
                switch (dimension) {
                    case 0: {
                        point.x = value;
                        return;
                    }
                    case 1: {
                        point.y = value;
                        return;
                    }
                    case 2: {
                        point.z = value;
                        return;
                    }
                }
            }
        };
    }

    public static void copy(Coordinate point, double[] ordinates) {
        JTS.ensureNonNull("point", point);
        JTS.ensureNonNull("ordinates", ordinates);
        switch (ordinates.length) {
            default: {
                Arrays.fill(ordinates, 3, ordinates.length, Double.NaN);
            }
            case 3: {
                ordinates[2] = point.z;
            }
            case 2: {
                ordinates[1] = point.y;
            }
            case 1: {
                ordinates[0] = point.x;
            }
            case 0: 
        }
    }

    public static Geometry shapeToGeometry(Shape shape, GeometryFactory factory) {
        return JTS.toGeometry(shape, factory);
    }

    public static Geometry toGeometry(Shape shape) {
        return JTS.toGeometry(shape, new GeometryFactory());
    }

    public static Geometry toGeometry(Shape shape, GeometryFactory factory) {
        JTS.ensureNonNull("shape", shape);
        JTS.ensureNonNull("factory", factory);
        PathIterator iterator = shape.getPathIterator(null, ShapeUtilities.getFlatness(shape));
        double[] buffer = new double[6];
        ArrayList coords = new ArrayList();
        ArrayList<Object> lines = new ArrayList<Object>();
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(buffer)) {
                case 4: {
                    if (coords.isEmpty()) break;
                    coords.add(coords.get(0));
                    lines.add(factory.createLinearRing(coords.toArray(new Coordinate[coords.size()])));
                    coords.clear();
                    break;
                }
                case 0: {
                    if (!coords.isEmpty()) {
                        lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                        coords.clear();
                    }
                }
                case 1: {
                    coords.add(new Coordinate(buffer[0], buffer[1]));
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            iterator.next();
        }
        if (!coords.isEmpty()) {
            lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
        }
        switch (lines.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (LineString)lines.get(0);
            }
        }
        return factory.createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    public static Envelope2D getEnvelope2D(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        SingleCRS crs2D;
        JTS.ensureNonNull("envelope", envelope);
        JTS.ensureNonNull("crs", crs);
        if (envelope instanceof ReferencedEnvelope) {
            ReferencedEnvelope referenced = (ReferencedEnvelope)envelope;
            CoordinateReferenceSystem implicitCRS = referenced.getCoordinateReferenceSystem();
            if (crs != null && !CRS.equalsIgnoreMetadata(crs, implicitCRS)) {
                throw new IllegalArgumentException(Errors.format(95, crs.getName().getCode(), implicitCRS.getName().getCode()));
            }
        }
        if ((crs2D = CRS.getHorizontalCRS(crs)) == null) {
            throw new MismatchedDimensionException(Errors.format(31, crs));
        }
        return new Envelope2D(crs2D, envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
    }

    public static Point toGeometry(DirectPosition position) {
        return JTS.toGeometry(position, null);
    }

    public static Point toGeometry(DirectPosition position, GeometryFactory factory) {
        if (factory == null) {
            factory = new GeometryFactory();
        }
        Coordinate coordinate = new Coordinate(position.getOrdinate(0), position.getOrdinate(1));
        if (position.getDimension() == 3) {
            coordinate.z = position.getOrdinate(2);
        }
        return factory.createPoint(coordinate);
    }

    public static Polygon toGeometry(Envelope env) {
        return JTS.toGeometry(env, new GeometryFactory());
    }

    public static Polygon toGeometry(Envelope env, GeometryFactory factory) {
        JTS.ensureNonNull("env", env);
        if (factory == null) {
            factory = new GeometryFactory();
        }
        return factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMinX(), env.getMinY())}), null);
    }

    public static ReferencedEnvelope toEnvelope(Geometry geom) {
        if (geom == null) {
            return null;
        }
        String srsName = null;
        Object userData = geom.getUserData();
        if (userData != null && userData instanceof String) {
            srsName = (String)userData;
        } else if (geom.getSRID() > 0) {
            srsName = "EPSG:" + geom.getSRID();
        }
        CoordinateReferenceSystem crs = null;
        if (userData != null && userData instanceof CoordinateReferenceSystem) {
            crs = (CoordinateReferenceSystem)userData;
        } else if (srsName != null) {
            try {
                crs = CRS.decode(srsName);
            }
            catch (NoSuchAuthorityCodeException e) {
            }
            catch (FactoryException e) {
                // empty catch block
            }
        }
        return new ReferencedEnvelope(geom.getEnvelopeInternal(), crs);
    }

    public static Polygon toGeometry(ReferencedEnvelope bbox) {
        return JTS.toGeometry(bbox, new GeometryFactory());
    }

    public static Polygon toGeometry(BoundingBox bbox, GeometryFactory factory, int npoints) {
        ++npoints;
        if (bbox == null) {
            return null;
        }
        if (factory == null) {
            factory = new GeometryFactory();
        }
        Coordinate[] coordinates = new Coordinate[4 * npoints];
        double xmin = bbox.getMinX();
        double xmax = bbox.getMaxX();
        double ymin = bbox.getMinY();
        double ymax = bbox.getMaxY();
        double scaleX = (xmax - xmin) / (double)npoints;
        double scaleY = (ymax - ymin) / (double)npoints;
        int top = 0;
        int right = npoints;
        int bottom = npoints * 2;
        int left = npoints * 3;
        for (int t = 0; t < npoints; ++t) {
            double dx = scaleX * (double)t;
            double dy = scaleY * (double)t;
            coordinates[top + t] = new Coordinate(xmin + dx, ymax);
            coordinates[left + t] = new Coordinate(xmin, ymin + dy);
            coordinates[bottom + t] = new Coordinate(xmax - dx, ymin);
            coordinates[right + t] = new Coordinate(xmax, ymax - dy);
        }
        return factory.createPolygon(factory.createLinearRing(coordinates), null);
    }

    public static Polygon toGeometry(BoundingBox bbox) {
        return JTS.toGeometry(bbox, new GeometryFactory());
    }

    public static Polygon toGeometry(BoundingBox bbox, GeometryFactory factory) {
        JTS.ensureNonNull("bbox", bbox);
        JTS.ensureNonNull("factory", factory);
        return factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(bbox.getMinX(), bbox.getMinY()), new Coordinate(bbox.getMaxX(), bbox.getMinY()), new Coordinate(bbox.getMaxX(), bbox.getMaxY()), new Coordinate(bbox.getMinX(), bbox.getMaxY()), new Coordinate(bbox.getMinX(), bbox.getMinY())}), null);
    }

    public static void checkCoordinatesRange(Geometry geom, CoordinateReferenceSystem crs) throws PointOutsideEnvelopeException {
        boolean yUnbounded;
        CoordinateSystemAxis x = crs.getCoordinateSystem().getAxis(0);
        CoordinateSystemAxis y = crs.getCoordinateSystem().getAxis(1);
        boolean xUnbounded = Double.isInfinite(x.getMinimumValue()) && Double.isInfinite(x.getMaximumValue());
        boolean bl = yUnbounded = Double.isInfinite(y.getMinimumValue()) && Double.isInfinite(y.getMaximumValue());
        if (xUnbounded && yUnbounded) {
            return;
        }
        Coordinate[] c = geom.getCoordinates();
        for (int i = 0; i < c.length; ++i) {
            if (!xUnbounded && (c[i].x < x.getMinimumValue() || c[i].x > x.getMaximumValue())) {
                throw new PointOutsideEnvelopeException(c[i].x + " outside of (" + x.getMinimumValue() + "," + x.getMaximumValue() + ")");
            }
            if (yUnbounded || !(c[i].y < y.getMinimumValue()) && !(c[i].y > y.getMaximumValue())) continue;
            throw new PointOutsideEnvelopeException(c[i].y + " outside of (" + y.getMinimumValue() + "," + y.getMaximumValue() + ")");
        }
    }

    public static Geometry smooth(Geometry geom, double fit) {
        return JTS.smooth(geom, fit, new GeometryFactory());
    }

    public static Geometry smooth(Geometry geom, double fit, GeometryFactory factory) {
        JTS.ensureNonNull("geom", geom);
        JTS.ensureNonNull("factory", factory);
        fit = Math.max(0.0, Math.min(1.0, fit));
        return JTS.smooth(geom, fit, factory, new GeometrySmoother(factory));
    }

    private static Geometry smooth(Geometry geom, double fit, GeometryFactory factory, GeometrySmoother smoother) {
        switch (Geometries.get(geom)) {
            case POINT: 
            case MULTIPOINT: {
                return geom;
            }
            case LINESTRING: {
                return JTS.smoothLineString(factory, smoother, geom, fit);
            }
            case MULTILINESTRING: {
                return JTS.smoothMultiLineString(factory, smoother, geom, fit);
            }
            case POLYGON: {
                return smoother.smooth((Polygon)geom, fit);
            }
            case MULTIPOLYGON: {
                return JTS.smoothMultiPolygon(factory, smoother, geom, fit);
            }
            case GEOMETRYCOLLECTION: {
                return JTS.smoothGeometryCollection(factory, smoother, geom, fit);
            }
        }
        throw new UnsupportedOperationException("No smoothing method available for " + geom.getGeometryType());
    }

    private static Geometry smoothLineString(GeometryFactory factory, GeometrySmoother smoother, Geometry geom, double fit) {
        if (geom instanceof LinearRing) {
            Polygon poly = factory.createPolygon((LinearRing)geom, null);
            Polygon smoothed = smoother.smooth(poly, fit);
            return smoothed.getExteriorRing();
        }
        return smoother.smooth((LineString)geom, fit);
    }

    private static Geometry smoothMultiLineString(GeometryFactory factory, GeometrySmoother smoother, Geometry geom, double fit) {
        int N = geom.getNumGeometries();
        LineString[] smoothed = new LineString[N];
        for (int i = 0; i < N; ++i) {
            smoothed[i] = (LineString)JTS.smoothLineString(factory, smoother, geom.getGeometryN(i), fit);
        }
        return factory.createMultiLineString(smoothed);
    }

    private static Geometry smoothMultiPolygon(GeometryFactory factory, GeometrySmoother smoother, Geometry geom, double fit) {
        int N = geom.getNumGeometries();
        Polygon[] smoothed = new Polygon[N];
        for (int i = 0; i < N; ++i) {
            smoothed[i] = smoother.smooth((Polygon)geom.getGeometryN(i), fit);
        }
        return factory.createMultiPolygon(smoothed);
    }

    private static Geometry smoothGeometryCollection(GeometryFactory factory, GeometrySmoother smoother, Geometry geom, double fit) {
        int N = geom.getNumGeometries();
        Geometry[] smoothed = new Geometry[N];
        for (int i = 0; i < N; ++i) {
            smoothed[i] = JTS.smooth(geom.getGeometryN(i), fit, factory, smoother);
        }
        return factory.createGeometryCollection(smoothed);
    }

    static {
        for (int i = 0; i < POSITIONS.length; ++i) {
            JTS.POSITIONS[i] = new GeneralDirectPosition(i);
        }
        CALCULATORS = new HashMap<CoordinateReferenceSystem, GeodeticCalculator>();
    }
}

