/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class GeometrySmoother {
    private SmootherControl DEFAULT_CONTROL = new SmootherControl(){

        @Override
        public double getMinLength() {
            return 0.0;
        }

        @Override
        public int getNumVertices(double length) {
            return 10;
        }
    };
    private SmootherControl control;
    private final GeometryFactory geomFactory;
    private Map<Integer, WeakReference<InterpPoint[]>> lookup = new HashMap<Integer, WeakReference<InterpPoint[]>>();

    GeometrySmoother(GeometryFactory geomFactory) {
        if (geomFactory == null) {
            throw new IllegalArgumentException("geomFactory must not be null");
        }
        this.geomFactory = geomFactory;
        this.control = this.DEFAULT_CONTROL;
    }

    LineString smooth(LineString ls, double alpha) {
        Coordinate[] coords = ls.getCoordinates();
        Coordinate[][] controlPoints = this.getLineControlPoints(coords, alpha);
        int N = coords.length;
        ArrayList<Coordinate> smoothCoords = new ArrayList<Coordinate>();
        for (int i = 0; i < N - 1; ++i) {
            double dist = coords[i].distance(coords[i + 1]);
            if (dist < this.control.getMinLength()) {
                smoothCoords.add(new Coordinate(coords[i]));
                continue;
            }
            int smoothN = this.control.getNumVertices(dist);
            Coordinate[] segment = this.cubicBezier(coords[i], coords[i + 1], controlPoints[i][1], controlPoints[i + 1][0], smoothN);
            int copyN = i < N - 1 ? segment.length - 1 : segment.length;
            for (int k = 0; k < copyN; ++k) {
                smoothCoords.add(segment[k]);
            }
        }
        smoothCoords.add(coords[N - 1]);
        return this.geomFactory.createLineString(smoothCoords.toArray(new Coordinate[0]));
    }

    public Polygon smooth(Polygon p, double alpha) {
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        int N = coords.length - 1;
        Coordinate[][] controlPoints = this.getPolygonControlPoints(coords, N, alpha);
        ArrayList<Coordinate> smoothCoords = new ArrayList<Coordinate>();
        for (int i = 0; i < N; ++i) {
            int next = (i + 1) % N;
            double dist = coords[i].distance(coords[next]);
            if (dist < this.control.getMinLength()) {
                smoothCoords.add(new Coordinate(coords[i]));
                continue;
            }
            int smoothN = this.control.getNumVertices(dist);
            Coordinate[] segment = this.cubicBezier(coords[i], coords[next], controlPoints[i][1], controlPoints[next][0], smoothN);
            int copyN = i < N - 1 ? segment.length - 1 : segment.length;
            for (int k = 0; k < copyN; ++k) {
                smoothCoords.add(segment[k]);
            }
        }
        LinearRing shell = this.geomFactory.createLinearRing(smoothCoords.toArray(new Coordinate[0]));
        return this.geomFactory.createPolygon(shell, null);
    }

    void setControl(SmootherControl control) {
        this.control = control == null ? this.DEFAULT_CONTROL : control;
    }

    private Coordinate[][] getLineControlPoints(Coordinate[] coords, double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha must be a value between 0 and 1 inclusive");
        }
        int N = coords.length;
        Coordinate[][] ctrl = new Coordinate[N][2];
        Coordinate[] v = new Coordinate[3];
        Coordinate[] mid = new Coordinate[]{new Coordinate(), new Coordinate()};
        Coordinate anchor = new Coordinate();
        double[] vdist = new double[2];
        v[1] = new Coordinate(2.0 * coords[0].x - coords[1].x, 2.0 * coords[0].y - coords[1].y);
        v[2] = coords[0];
        Coordinate vN = new Coordinate(2.0 * coords[N - 1].x - coords[N - 2].x, 2.0 * coords[N - 1].y - coords[N - 2].y);
        mid[1].x = (v[1].x + v[2].x) / 2.0;
        mid[1].y = (v[1].y + v[2].y) / 2.0;
        vdist[1] = v[1].distance(v[2]);
        for (int i = 0; i < N; ++i) {
            v[0] = v[1];
            v[1] = v[2];
            v[2] = i < N - 1 ? coords[i + 1] : vN;
            mid[0].x = mid[1].x;
            mid[0].y = mid[1].y;
            mid[1].x = (v[1].x + v[2].x) / 2.0;
            mid[1].y = (v[1].y + v[2].y) / 2.0;
            vdist[0] = vdist[1];
            vdist[1] = v[1].distance(v[2]);
            double p = vdist[0] / (vdist[0] + vdist[1]);
            anchor.x = mid[0].x + p * (mid[1].x - mid[0].x);
            anchor.y = mid[0].y + p * (mid[1].y - mid[0].y);
            double xdelta = anchor.x - v[1].x;
            double ydelta = anchor.y - v[1].y;
            ctrl[i][0] = new Coordinate(alpha * (v[1].x - mid[0].x + xdelta) + mid[0].x - xdelta, alpha * (v[1].y - mid[0].y + ydelta) + mid[0].y - ydelta);
            ctrl[i][1] = new Coordinate(alpha * (v[1].x - mid[1].x + xdelta) + mid[1].x - xdelta, alpha * (v[1].y - mid[1].y + ydelta) + mid[1].y - ydelta);
        }
        return ctrl;
    }

    private Coordinate[][] getPolygonControlPoints(Coordinate[] coords, int N, double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha must be a value between 0 and 1 inclusive");
        }
        Coordinate[][] ctrl = new Coordinate[N][2];
        Coordinate[] v = new Coordinate[3];
        Coordinate[] mid = new Coordinate[]{new Coordinate(), new Coordinate()};
        Coordinate anchor = new Coordinate();
        double[] vdist = new double[2];
        v[1] = coords[N - 1];
        v[2] = coords[0];
        mid[1].x = (v[1].x + v[2].x) / 2.0;
        mid[1].y = (v[1].y + v[2].y) / 2.0;
        vdist[1] = v[1].distance(v[2]);
        for (int i = 0; i < N; ++i) {
            v[0] = v[1];
            v[1] = v[2];
            v[2] = coords[(i + 1) % N];
            mid[0].x = mid[1].x;
            mid[0].y = mid[1].y;
            mid[1].x = (v[1].x + v[2].x) / 2.0;
            mid[1].y = (v[1].y + v[2].y) / 2.0;
            vdist[0] = vdist[1];
            vdist[1] = v[1].distance(v[2]);
            double p = vdist[0] / (vdist[0] + vdist[1]);
            anchor.x = mid[0].x + p * (mid[1].x - mid[0].x);
            anchor.y = mid[0].y + p * (mid[1].y - mid[0].y);
            double xdelta = anchor.x - v[1].x;
            double ydelta = anchor.y - v[1].y;
            ctrl[i][0] = new Coordinate(alpha * (v[1].x - mid[0].x + xdelta) + mid[0].x - xdelta, alpha * (v[1].y - mid[0].y + ydelta) + mid[0].y - ydelta);
            ctrl[i][1] = new Coordinate(alpha * (v[1].x - mid[1].x + xdelta) + mid[1].x - xdelta, alpha * (v[1].y - mid[1].y + ydelta) + mid[1].y - ydelta);
        }
        return ctrl;
    }

    private Coordinate[] cubicBezier(Coordinate start, Coordinate end, Coordinate ctrl1, Coordinate ctrl2, int nv) {
        Coordinate[] curve = new Coordinate[nv];
        Coordinate[] buf = new Coordinate[3];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = new Coordinate();
        }
        curve[0] = new Coordinate(start);
        curve[nv - 1] = new Coordinate(end);
        InterpPoint[] ip = this.getInterpPoints(nv);
        for (int i = 1; i < nv - 1; ++i) {
            Coordinate c = new Coordinate();
            c.x = ip[i].t[0] * start.x + ip[i].t[1] * ctrl1.x + ip[i].t[2] * ctrl2.x + ip[i].t[3] * end.x;
            c.x /= ip[i].tsum;
            c.y = ip[i].t[0] * start.y + ip[i].t[1] * ctrl1.y + ip[i].t[2] * ctrl2.y + ip[i].t[3] * end.y;
            c.y /= ip[i].tsum;
            curve[i] = c;
        }
        return curve;
    }

    private InterpPoint[] getInterpPoints(int npoints) {
        WeakReference<InterpPoint[]> ref = this.lookup.get(npoints);
        InterpPoint[] ip = null;
        if (ref != null) {
            ip = (InterpPoint[])ref.get();
        }
        if (ip == null) {
            ip = new InterpPoint[npoints];
            for (int i = 0; i < npoints; ++i) {
                double t = (double)i / (double)(npoints - 1);
                double tc = 1.0 - t;
                ip[i] = new InterpPoint();
                ip[i].t[0] = tc * tc * tc;
                ip[i].t[1] = 3.0 * tc * tc * t;
                ip[i].t[2] = 3.0 * tc * t * t;
                ip[i].t[3] = t * t * t;
                ip[i].tsum = ip[i].t[0] + ip[i].t[1] + ip[i].t[2] + ip[i].t[3];
            }
            this.lookup.put(npoints, new WeakReference<InterpPoint[]>(ip));
        }
        return ip;
    }

    private static final class InterpPoint {
        double[] t = new double[4];
        double tsum;

        private InterpPoint() {
        }
    }

    private static interface SmootherControl {
        public double getMinLength();

        public int getNumVertices(double var1);
    }
}

