/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.identity;

import java.util.Date;
import org.geotools.filter.identity.FeatureIdVersionedImpl;
import org.geotools.util.Utilities;
import org.opengis.filter.identity.ResourceId;
import org.opengis.filter.identity.Version;

public class ResourceIdImpl
extends FeatureIdVersionedImpl
implements ResourceId {
    private Date startTime;
    private Date endTime;
    private long version;

    public ResourceIdImpl(String fid, String featureVersion, Version version) {
        super(fid, featureVersion, null);
        this.setVersion(version);
    }

    public ResourceIdImpl(String fid, String featureVersion) {
        this(fid, featureVersion, (Version)null);
    }

    public ResourceIdImpl(String fid, Date start, Date end) {
        this(fid, (String)null, (Version)null);
        if (start == null && end == null) {
            throw new NullPointerException("At least one of start and end time are required for a lookup based on a date range");
        }
        this.startTime = start;
        this.endTime = end;
    }

    public void setRid(String rid) {
        this.setID(rid);
    }

    public void setPreviousRid(String previousRid) {
        this.previousRid = previousRid;
    }

    public void setVersion(Version version) {
        this.version = version == null ? new Version().union() : version.union();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Version getVersion() {
        return Version.valueOf((long)this.version);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceId)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ResourceId o = (ResourceId)obj;
        return Utilities.equals(this.featureVersion, o.getFeatureVersion()) && Utilities.equals(this.previousRid, o.getPreviousRid()) && Utilities.equals((Object)this.version, o.getVersion()) && Utilities.equals(this.startTime, o.getStartTime()) && Utilities.equals(this.endTime, o.getEndTime());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = Utilities.hash(this.previousRid, hash);
        hash = Utilities.hash(this.version, hash);
        hash = Utilities.hash(this.startTime, hash);
        hash = Utilities.hash(this.endTime, hash);
        return hash;
    }
}

